import-module -name $PSScriptRoot\..\dadosValidacao.psm1

function global:mu.validador.usuarioEhAdministrador() {
    param(
        [Parameter(ValueFromPipeline)]
        $dadosValidacao
    )

    if ($dadosValidacao.configuracaoValida -eq $false) {
        return $dadosValidacao
    }

    _echo "Verificando se usuario eh administrador"

    $usuario = $dadosValidacao.configuracoes.acessos.usuarioAdministrador.usuario

    $resultado = Get-LocalGroupMember -Name administrators | Where-Object {$_.Name -match ($usuario + "$")}

    _echo $resultado

    if ($resultado.length -eq 0 -or $usuario -eq "" -or $null -eq $usuario) {
        $dadosValidacao.configuracaoValida = $false
        $dadosValidacao.codigoErro = "E0002"
        $dadosValidacao.mensagemErro = "Usuario informado nao existe ou nao eh um administrador local"
        
    }

    return $dadosValidacao
}

