import-module -name $PSScriptRoot\..\dadosValidacao.psm1
. $PSScriptRoot\..\..\_echo.ps1

function global:mu.validador.moduloPowershellYamlInstalado() {
    param(
        [Parameter(ValueFromPipeline)]
        $dadosValidacao
    )

    if ($dadosValidacao.configuracaoValida -eq $false) {
        return $dadosValidacao
    }

    _echo "Verificando se modulo powershell-yaml esta instalado"

    if (!(Get-Module -ListAvailable -Name "powershell-yaml")) {
        $dadosValidacao.codigoErro = "E0006"
        $dadosValidacao.mensagemErro = "Módulo powershell-yaml não está instalado"
        $dadosValidacao.configuracaoValida = $false
    }

    return $dadosValidacao
}