import-module -name $PSScriptRoot\..\dadosValidacao.psm1

. $PSScriptRoot\..\..\_echo.ps1

function global:mu.validador.enterprisePodeSerExecutado() {
    param(
        [Parameter(ValueFromPipeline)]
        $dadosValidacao
    )

    $sistema = $dadosValidacao.configuracoes.enterprise.imagem.sistema

    if ($dadosValidacao.configuracaoValida -eq $false) {
        return $dadosValidacao
    }

    if ($dadosValidacao.configuracoes.enterprise.configurar -eq $false) {
        return $dadosValidacao
    }

    # _echo "Verificando se API Enterprise pode ser executada"

    # if ((Get-Command docker | Measure-Object).Count -eq 0) {
    #     $dadosValidacao.codigoErro = "E0007"
    #     $dadosValidacao.configuracaoValida = $false
    #     $dadosValidacao.mensagemErro = "Docker nao esta instalado. Impossivel configurar o enterprise. Consulte http://54.165.49.155:8090/display/FNX/Enterprise para mais informações"
    # }

    # if ($sistema -eq "windows" -and !(mu.dockerEstaRodandoNoContextoWindows)) {
    #     $dadosValidacao.codigoErro = "E0008"
    #     $dadosValidacao.configuracaoValida = $false
    #     $dadosValidacao.mensagemErro = "Docker nao esta rodando para imagens do windows. Consulte http://54.165.49.155:8090/display/FNX/Enterprise para mais informações"
    # }

    # if (!(mu.loginEnterpriseRegistryOk $dadosValidacao.configuracoes)) {
    #     $dadosValidacao.codigoErro = "E0009"
    #     $dadosValidacao.configuracaoValida = $false
    #     $dadosValidacao.mensagemErro = "Login no container de imagens do docker falhou"
    # }

    # if (!(mu.imagemEnterpriseExiste $dadosValidacao.configuracoes)) {
    #     $dadosValidacao.codigoErro = "E000A"
    #     $dadosValidacao.configuracaoValida = $false
    #     $nomeImagemCompleta = "$($dadosValidacao.configuracoes.enterprise.imagem.nome):$($dadosValidacao.configuracoes.enterprise.imagem.versao)"
    #     $dadosValidacao.mensagemErro = "Imagem/tag do enterprise inexistente: $nomeImagemCompleta"
    # }

    return $dadosValidacao
}

function global:mu.dockerEstaRodandoNoContextoWindows {
    $ProgressPreference_back = $ProgressPreference
    $ProgressPreference = 'SilentlyContinue'
    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    $ehWindowsServer = (Get-ComputerInfo 2> $null 3> $null | Select-Object WindowsProductName ) -match "Windows Server"
    $ProgressPreference = $ProgressPreference_back

    $result = if ($ehWindowsServer) {
        $true
    } else {
        (docker info | findstr "Context") -match "desktop-windows"
    }

    $result = (docker info | findstr "Context") -match "desktop-windows"

    $ErrorActionPreference = $ErrorActionPreference_back

    return $result
}

function global:mu.loginEnterpriseRegistryOk {
    param(
        $configuracoes
    )

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    $enderecoRegistro = $configuracoes.enterprise.imagem.nome.Split('/')[0]
    $result = (docker login $enderecoRegistro -u $configuracoes.enterprise.imagem.usuario -p $configuracoes.enterprise.imagem.senha) -match "Login succeeded" 2> $null

    $ErrorActionPreference = $ErrorActionPreference_back

    return $result
}

function global:mu.imagemEnterpriseExiste {
    param(
        $configuracoes
    )

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    docker manifest inspect "$($configuracoes.enterprise.imagem.nome):$($configuracoes.enterprise.imagem.versao)"

    $result = $LASTEXITCODE -eq 0

    $ErrorActionPreference = $ErrorActionPreference_back
    
    return $result
}

function global:mu.dockerEstaRodandoNoContextoWindows.test {
    _echo mu.validador.dockerEstaRodandoNoContextoWindows 

    
}

