import-module -name $PSScriptRoot\..\dadosValidacao.psm1
. $PSScriptRoot\..\..\_echo.ps1

function global:mu.validador.branchWMSExiste() {
    param(
        [Parameter(ValueFromPipeline)]
        $dadosValidacao
    )

    if ($dadosValidacao.configuracaoValida -eq $false) {
        return $dadosValidacao
    }

    if ($dadosValidacao.configuracoes.monitorWMS.configurar -eq $false) {
        return $dadosValidacao
    }

    _echo "Verificando se branch do MonitorWMS existe"

    $usuario = "oauth2"
    $senha = "glpat-ojWVRhdXgwxMxtJYRHvs"
    $referencia = $dadosValidacao.configuracoes.monitorWMS.referencia

    if ($referencia -match "[0-9a-f]{40}") {    # se for sha1, não valida
        return $dadosValidacao
    }

    $url = "https://${usuario}:${senha}@gitlab.microuniverso.com.br/microuniverso/MUFenix/MonitorIntegracaoWMSRelease.git"

    $resultado = (git ls-remote --heads --tags $url $referencia | Measure-Object -line).Lines

    if ($resultado -eq 0) {
        $dadosValidacao.codigoErro = "E000C"
        $dadosValidacao.mensagemErro = "Branch/tag WMS inexistente"
        $dadosValidacao.configuracaoValida = $false
    }

    return $dadosValidacao
}