import-module -name $PSScriptRoot\..\dadosValidacao.psm1
. $PSScriptRoot\..\..\_echo.ps1

function global:mu.validador.branchExiste() {
    param(
        [Parameter(ValueFromPipeline)]
        $dadosValidacao
    )

    if ($dadosValidacao.configuracaoValida -eq $false) {
        return $dadosValidacao
    }

    $prosseguirComVerificacao = $dadosValidacao.configuracoes.servicos.rest.configurar -or `
        $dadosValidacao.configuracoes.servicos.authServer.configurar -or `
        $dadosValidacao.configuracoes.servicos.resourceServer.configurar -or `
        $dadosValidacao.configuracoes.servicos.segurancaWeb.configurar -or `
        $dadosValidacao.configuracoes.servicos.imagensProdutos.configurar -or `
        $dadosValidacao.configuracoes.servicos.orcamentoWeb.configurar -or `
        $dadosValidacao.configuracoes.servicos.carrinhoDeCompra.configurar -or `
        $dadosValidacao.configuracoes.servicos.financeiro.configurar -or `
        $dadosValidacao.configuracoes.servicos.liberarPendencia.configurar -or `
        $dadosValidacao.configuracoes.enterprise.configurar

    if (-not $prosseguirComVerificacao) {
        return $dadosValidacao
    }

    _echo "Verificando se branch existe"

    $usuarioEncoded = $dadosValidacao.configuracoes.acessos.git.usuario
    $senhaEncoded = $dadosValidacao.configuracoes.acessos.git.senha
    $referencia = $dadosValidacao.configuracoes.dadosRelease.referencia

    if ($referencia -match "[0-9a-f]{40}") {    # se for sha1, não valida
        return $dadosValidacao
    }

    $url = "https://${usuarioEncoded}:${senhaEncoded}@gitlab.microuniverso.com.br/Microuniverso/MUFenix/ReleaseWeb.git"

    $resultado = (git ls-remote --heads --tags $url $referencia | Measure-Object -line).Lines

    if ($resultado -eq 0) {
        $dadosValidacao.codigoErro = "E0005"
        $dadosValidacao.mensagemErro = "Branch/tag inexistente"
        $dadosValidacao.configuracaoValida = $false
    }

    return $dadosValidacao
}