import-module -name $PSScriptRoot\..\dadosValidacao.psm1
. $PSScriptRoot\..\..\_echo.ps1
. $PSScriptRoot\..\..\criptografiaSenha.ps1


function global:mu.validador.acessoAoBanco() {
    param(
        [Parameter(ValueFromPipeline)]
        $dadosValidacao
    )

    if ($dadosValidacao.configuracaoValida -eq $false) {
        return $dadosValidacao
    }

    $prosseguirComVerificacao = $dadosValidacao.configuracoes.servicos.rest.configurar -or `
        $dadosValidacao.configuracoes.servicos.authServer.configurar -or `
        $dadosValidacao.configuracoes.servicos.resourceServer.configurar -or `
        $dadosValidacao.configuracoes.servicos.segurancaWeb.configurar -or `
        $dadosValidacao.configuracoes.servicos.imagensProdutos.configurar -or `
        $dadosValidacao.configuracoes.servicos.orcamentoWeb.configurar -or `
        $dadosValidacao.configuracoes.servicos.carrinhoDeCompra.configurar -or `
        $dadosValidacao.configuracoes.servicos.financeiro.configurar -or `
        $dadosValidacao.configuracoes.servicos.liberarPendencia.configurar -or `
        $dadosValidacao.configuracoes.enterprise.configurar

    if (-not $prosseguirComVerificacao) {
        return $dadosValidacao
    }

    _echo "Verificando acesso ao banco"

    $usuario = $dadosValidacao.configuracoes.acessos.banco.usuario
    $senha = mu.descriptografarSenha($dadosValidacao.configuracoes.acessos.banco.senha)
    $enderecoHost = $dadosValidacao.configuracoes.acessos.banco.host
    $enderecoHostCorrigido = $enderecoHost -replace "\\","/"
    $banco = $dadosValidacao.configuracoes.acessos.banco.nomeBanco

    $_ErrorActionPreference = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'    
    $out = npm run --prefix $PSScriptRoot\..\..\ testar-acesso-ao-banco -- --user $usuario --password $senha --host $enderecoHostCorrigido --database $banco
    $ErrorActionPreference = $_ErrorActionPreference
    

    $resultado = $out -match "ERRO$"


    if ($resultado -eq "ERRO") {
        $dadosValidacao.configuracaoValida = $false
        $dadosValidacao.codigoErro = "E0001"
        $dadosValidacao.mensagemErro = "Nao foi possivel se conectar ao banco de dados"
    }

    return $dadosValidacao
}