using module .\dadosValidacao.psm1

. $PSScriptRoot\validadores\versaoPowerShell.ps1
. $PSScriptRoot\validadores\acessoAoBanco.ps1
. $PSScriptRoot\validadores\usuarioEhAdministrador.ps1
. $PSScriptRoot\validadores\dadosUsuarioValidos.ps1
. $PSScriptRoot\validadores\branchExiste.ps1
. $PSScriptRoot\validadores\moduloPowershellYamlInstalado.ps1
. $PSScriptRoot\validadores\enterprisePodeSerExecutado.ps1
. $PSScriptRoot\..\validarComandoAnterior.ps1
. $PSScriptRoot\..\_echo.ps1
. $PSScriptRoot\validadores\acessoAoBancoWMS.ps1
. $PSScriptRoot\validadores\branchWMSExiste.ps1



function global:mu.executarValidacoes() {
    param(
        $configuracoes
    )

    $dadosValidacao = [DadosValidacao]@{
        configuracaoValida = $true
        codigoErro = ""
        mensagemErro = ""
        configuracoes = $configuracoes
    }

    $dadosValidados = $dadosValidacao |
        mu.validador.versaoPowerShell | 
        mu.validador.moduloPowershellYamlInstalado |
        mu.validador.acessoAoBanco | 
        mu.validador.dadosUsuarioValidos |
        mu.validador.branchExiste |
        mu.validador.enterprisePodeSerExecutado |
        mu.validador.acessoAoBancoWMS |
        mu.validador.branchWMSExiste

    if ($dadosValidados.configuracaoValida -eq $false) {
        throw "$($dadosValidados.codigoErro) - $($dadosValidados.mensagemErro)"
    }
}

function global:mu.executarValidacoes.test() {
    
    . $PSScriptRoot\..\configuracoesMicrouniversoWeb.ps1

    $enderecoArquivoConfiguracao = "C:\microuniversoWeb\microuniversoWeb-enterprise.yaml"

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao

    mu.executarValidacoes $configuracoes
}