const {argv} = require('yargs')
const {updateConfigurationFile} = require('.\\updateConfigurationFile')

async function main() {
    const currentConfigurationFilePath = argv["currentConfigurationFilePath"]
    const updatedModelConfigurationFilePath = argv["updatedModelConfigurationFilePath"]
    const outputFilePath = argv["outputFilePath"]

    await updateConfigurationFile({
        currentConfigurationFilePath,
        updatedModelConfigurationFilePath,
        outputFilePath
    })
}

main().then(() => process.exit(0)).catch(error => {
    console.error(error)
    process.exit(1)
})