import unittest
from lib.configurar_api_gateway import criar_conteudo_docker_compose, escrever_conteudo_docker_compose, ajustar_enderecos_backends,executar_configuracao_completa
import tempfile
import yaml
from pprint import pprint
import shutil
import os
from lib.ClienteLinux import obter_cliente_linux

class TestConfigurarApiGateway(unittest.TestCase):

    def test_criar_docker_compose(self):
        arquivo_yml_temporario = tempfile.NamedTemporaryFile(suffix='.yml',delete=False).name

        configuracoes = {
            'api-gateway': {
                'porta': 80
            
            }
        }
        
        escrever_conteudo_docker_compose(
            conteudo = criar_conteudo_docker_compose(
                configuracoes
            ),
            endereco_arquivo=arquivo_yml_temporario
        )

        print(arquivo_yml_temporario)

        print(open(arquivo_yml_temporario).read())

    def test_carregar_microuniverso_web_yaml(self):
        arquivo_configuracoes = r'C:\TrabalhoWeb\ScriptsDeploy\scripts_implantacao\microuniversoWeb-modelo.yaml'

        with open(arquivo_configuracoes, 'r') as arquivo:
            configuracoes = yaml.safe_load(arquivo)

        pprint(configuracoes["api-gateway"])

    def test_ajustar_enderecos_backends_somente_gerar_conteudo(self):
        arquivo_config = r'C:\TrabalhoWeb\ScriptsDeploy\scripts_implantacao\api-gateway\config\api-backends.conf'

        configuracoes = {
            "api-gateway": {
                "backends": [
                    {
                        "nome": "ApiEnterprise",
                        "host": "host-enterprise",
                        "porta": "9988"
                    },
                    {
                        "nome": "Rest",
                        "host": "host-rest",
                        "porta": "9990"
                    }
                ]
            }
        }

        print(ajustar_enderecos_backends(arquivo_config, configuracoes))

    def test_ajustar_enderecos_backends_alterar_arquivo_no_disco(self):
        arquivo_config_original = r'C:\TrabalhoWeb\ScriptsDeploy\scripts_implantacao\api-gateway\config\api-backends.conf'

        arquivo_config_para_alterar = tempfile.NamedTemporaryFile(suffix='.conf',delete=False).name

        shutil.copy(arquivo_config_original, arquivo_config_para_alterar)

        configuracoes = {
            "api-gateway": {
                "backends": [
                    {
                        "nome": "ApiEnterprise",
                        "host": "host-enterprise",
                        "porta": "9988"
                    },
                    {
                        "nome": "Rest",
                        "host": "host-rest",
                        "porta": "9990"
                    }
                ]
            }
        }

        ajustar_enderecos_backends(arquivo_config_para_alterar, configuracoes, substituir=True)

        print(arquivo_config_para_alterar)
        print(open(arquivo_config_para_alterar).read())

    def test_executar_configuracao_completa(self):
        configuracoes = {
            'acessos': {
                'servidorLinux': {
                    'tipoConexao': 'WSL',
                    'usuario': os.getenv('USUARIO_WSL', None),
                    'senha': os.getenv('SENHA_WSL', None)
                }
            },
            'api-gateway': {
                'porta': 80,
                'backends': [
                    {
                        'nome': 'ApiEnterprise',
                        'host': '10.10.10.205',
                        'porta': '5000'
                    },
                    {
                        'nome': 'Rest',
                        'host': '10.10.10.205',
                        'porta': '9990'
                    }
                ]
            }
        }

        diretorio_scripts_implentacao = r'C:\TrabalhoWeb\ScriptsDeploy\scripts_implantacao'

        executar_configuracao_completa(
            configuracoes=configuracoes,
            diretorio_scripts_implantacao=diretorio_scripts_implentacao
        )

    def test_escrever_em_arquivo_com_multiplas_linhas(self):
        configuracoes = {
            'acessos': {
                'servidorLinux': {
                    'tipoConexao': 'WSL',
                    'usuario': os.getenv('USUARIO_WSL', None),
                    'senha': os.getenv('SENHA_WSL', None)
                }
            }
        }
        
        cliente_linux = obter_cliente_linux(configuracoes=configuracoes)

        cliente_linux.executar_comando(f"""
            
            echo -e '#!/bin/sh\n' > /tmp/arquivo-com-multiplas-linhas
            echo -e 'rm /etc/nginx/conf.d/default.conf\n' >> /tmp/arquivo-com-multiplas-linhas
            """)