from pathlib import Path
from lib.ClienteLinux import obter_cliente_linux
from lib.obter_configuracoes import obter_configuracoes


def executar_validacoes_servidor_linux(arquivo_configuracao, diretorio_scripts_implantacao):
    if not arquivo_configuracao or not Path(arquivo_configuracao).exists():
        return "Arquivo de configuracao nao informado ou inexistente"
    

    if not diretorio_scripts_implantacao or not Path(diretorio_scripts_implantacao).exists():
        return f"Diretorio de scripts de implantacao {diretorio_scripts_implantacao} nao encontrado"
    
    cliente_linux = obter_cliente_linux(arquivo_configuracao)


    if not cliente_linux or not cliente_linux.conexao_ok():
        return f"Não foi possível conectar ao servidor Linux. Dados de conexao: {cliente_linux.obter_dados_cliente_linux()}"
    
    configuracoes = obter_configuracoes(arquivo_configuracao)    
    
    usuario = configuracoes['acessos']['servidorLinux']['usuario']

    if cliente_linux.executar_comando(f'test -z `which docker`', disparar_excecao_se_retorno_nao_zero=False).codigo_retorno == 0:
        return "docker nao esta instalado"
    
    if cliente_linux.executar_comando(f'test -z `cat /etc/passwd | egrep ^{usuario}:`', disparar_excecao_se_retorno_nao_zero=False).codigo_retorno == 0:
        return f"Usuario {usuario} nao encontrado"
    
    if cliente_linux.executar_comando(f'test -z `groups {usuario} | grep docker`', disparar_excecao_se_retorno_nao_zero=False).codigo_retorno == 0:
        return f"Usuario {usuario} nao pertence ao grupo docker"
    
    return None