from lib.obter_configuracoes import obter_configuracoes
import sys
from lib.echo import echo
from lib.executar_validacoes_servidor_linux import executar_validacoes_servidor_linux
from lib.ClienteLinux import obter_cliente_linux


arquivo_configuracao = None if len(sys.argv) < 2 else sys.argv[1]
diretorio_scripts_implantacao = r'c:\micoruniversoWeb\scriptsImplantacao' if len(sys.argv) < 3 else sys.argv[2]

configuracoes = obter_configuracoes(arquivo_configuracao)

if not configuracoes["acessos"]["servidorLinux"]["configurar"]:
    echo("Dados do servidor linux nao informados. Coleta de preco nao sera configurada")
    exit(0)

if not configuracoes["coletaPrecos"]["configurar"]:
    echo("Configuracao da coleta de preços desativada via configuracao")
    exit(0)

mensagem_erro = executar_validacoes_servidor_linux(arquivo_configuracao, diretorio_scripts_implantacao)    

if mensagem_erro:
    echo(mensagem_erro, "error")
    exit(1)

cliente_linux = obter_cliente_linux(arquivo_configuracao)

usuario = configuracoes['acessos']['servidorLinux']['usuario']

if cliente_linux.executar_comando(f"test ! -d /home/{usuario}/coletaPrecos", disparar_excecao_se_retorno_nao_zero=False).codigo_retorno == 0:
    cliente_linux.executar_comando(f'mkdir /home/{usuario}/coletaPrecos')

cliente_linux.copiar_arquivo(fr'{diretorio_scripts_implantacao}\coletaPreco\docker-compose-coleta-preco.yml' , f'/home/{usuario}/coletaPrecos/docker-compose.yml')

url_api_gateway = "{protocolo}://{host}:{porta}".format(
    protocolo="http",
    host=configuracoes["coletaPrecos"]["gateway"]["host"],
    porta=configuracoes["coletaPrecos"]["gateway"]["porta"]
)


porta_coletaprecos = configuracoes["coletaPrecos"]["porta"]
versao = configuracoes["coletaPrecos"]["versao"]
usuario_registro_docker = configuracoes["acessos"]["registroDocker"]["usuario"]
senha_registro_docker = configuracoes["acessos"]["registroDocker"]["senha"]
usuario_coleta_preco = configuracoes["coletaPrecos"]["usuario"]
senha_coleta_preco = configuracoes["coletaPrecos"]["senha"]

cliente_linux.executar_comando(fr'docker login gitlab.microuniverso.com.br:5050 -u {usuario_registro_docker} -p {senha_registro_docker}', disparar_excecao_se_retorno_nao_zero=False)

cliente_linux.executar_comando(f"sed -i 's,\$PORTA,{porta_coletaprecos},g' /home/{usuario}/coletaPrecos/docker-compose.yml")
cliente_linux.executar_comando(fr"sed -i 's,\$URL_API_GATEWAY,{url_api_gateway},g' /home/{usuario}/coletaPrecos/docker-compose.yml")
cliente_linux.executar_comando(fr"sed -i 's,\$VERSAO,{versao},g' /home/{usuario}/coletaPrecos/docker-compose.yml")
cliente_linux.executar_comando(fr"sed -i 's,\$USUARIO_COLETA,{usuario_coleta_preco},g' /home/{usuario}/coletaPrecos/docker-compose.yml")
cliente_linux.executar_comando(fr"sed -i 's,\$SENHA_COLETA,{senha_coleta_preco},g' /home/{usuario}/coletaPrecos/docker-compose.yml")

cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/coletaPrecos/docker-compose.yml down')    
cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/coletaPrecos/docker-compose.yml pull')
cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/coletaPrecos/docker-compose.yml up -d')    

exit(0)

