import sys
from lib.configurar_api_gateway import executar_configuracao_completa
from lib.obter_configuracoes import obter_configuracoes
from lib.echo import echo
from lib.executar_validacoes_servidor_linux import executar_validacoes_servidor_linux

arquivo_configuracao = None if len(sys.argv) < 2 else sys.argv[1]
diretorio_scripts_implantacao = r'c:\microuniversoWeb' if len(sys.argv) < 3 else sys.argv[2]

configuracoes = obter_configuracoes(arquivo_configuracao)

if not configuracoes:
    echo(f"Falha ao carregar configuracoes do arquivo {arquivo_configuracao}" , "error")
    exit(1)

if not configuracoes["acessos"]["servidorLinux"]["configurar"]:
    echo("Dados do servidor linux nao informados. API Gateway nao sera configurada")
    exit(0)

if not configuracoes["api-gateway"]["configurar"]:
    echo(f"Configuracao da API Gateway desativada via configuracao")
    exit(0)

mensagem_erro = executar_validacoes_servidor_linux(arquivo_configuracao, diretorio_scripts_implantacao)    

if mensagem_erro:
    echo(mensagem_erro, "error")
    exit(1)

executar_configuracao_completa(configuracoes, diretorio_scripts_implantacao)    