from lib.ClienteLinux import obter_cliente_linux
from lib.echo import echo
import sys
from pathlib import Path
from lib.obter_configuracoes import obter_configuracoes
from lib.criptografia_senha import descriptografar
from lib.executar_validacoes_servidor_linux import executar_validacoes_servidor_linux


arquivo_configuracao = None if len(sys.argv) < 2 else sys.argv[1]
diretorio_scripts_implantacao = r'c:\microuniversoWeb' if len(sys.argv) < 3 else sys.argv[2]

configuracoes = obter_configuracoes(arquivo_configuracao)

if not configuracoes:
    echo(f"Falha ao carregar configuracoes do arquivo {arquivo_configuracao}" , "error")
    exit(1)

if not configuracoes["acessos"]["servidorLinux"]["configurar"]:
    echo("Dados do servidor linux nao informados. API Enterprise nao sera configurada")
    exit(0)

if not configuracoes["enterprise"]["configurar"]:
    echo(f"Configuracao da API Enterprise desativada via configuracao")
    exit(0)

mensagem_erro = executar_validacoes_servidor_linux(arquivo_configuracao, diretorio_scripts_implantacao)    

if mensagem_erro:
    echo(mensagem_erro, "error")
    exit(1)

cliente_linux = obter_cliente_linux(arquivo_configuracao)


usuario = configuracoes['acessos']['servidorLinux']['usuario']    


if cliente_linux.executar_comando(f"test ! -d /home/{usuario}/enterprise", disparar_excecao_se_retorno_nao_zero=False).codigo_retorno == 0:
    cliente_linux.executar_comando(f'mkdir /home/{usuario}/enterprise')

cliente_linux.copiar_arquivo(fr'{diretorio_scripts_implantacao}\enterprise\docker-compose-enterprise-linux.yml' , f'/home/{usuario}/enterprise/docker-compose.yml')

imagem_enterprise = configuracoes["enterprise"]["imagem"]["nome"] + ":" + configuracoes["enterprise"]["imagem"]["versao"]
configurar_event_handler = configuracoes["enterprise"]["eventHandler"]["configurar"]
microkafka_host = configuracoes["enterprise"]["eventHandler"]["hostMicrokafka"]
host_banco = configuracoes["acessos"]["banco"]["host"]
usuario_banco = configuracoes["acessos"]["banco"]["usuario"]
senha_banco = descriptografar(configuracoes["acessos"]["banco"]["senha"])
nome_banco = configuracoes["acessos"]["banco"]["nomeBanco"]
ip_host = configuracoes["enderecos"]["ipHost"]
porta_mu_dll_rest = configuracoes["muDllRest"]["porta"]
porta_enterprise = configuracoes["enterprise"]["porta"]
neocredit_envio_processamento_url = configuracoes["enterprise"]["neocredit"]["urlProcessamento"]
neocredit_token = configuracoes["enterprise"]["neocredit"]["tokenNeocredit"]
neocredit_url_webhook = configuracoes["enterprise"]["neocredit"]["urlWebhook"]
porta_rest_legado = configuracoes["servicos"]["rest"]["porta"]
sql_server_2008 = "S" if configuracoes["enterprise"]["usarSQLServer2008"] else "N"
usuario_registro_docker = configuracoes["acessos"]["registroDocker"]["usuario"]
senha_registro_docker = configuracoes["acessos"]["registroDocker"]["senha"]
ativar_reprocessamento_custo_medio_online = "S" if configuracoes["enterprise"]["reprocessamentoCustoMedioOnline"]["ativar"] else "N"
hora_reprocessamento_custo_medio_online = configuracoes["enterprise"]["reprocessamentoCustoMedioOnline"]["hora"]
minuto_reprocessamento_custo_medio_online = configuracoes["enterprise"]["reprocessamentoCustoMedioOnline"]["minuto"]
ativar_job_retorno_coleta_preco_sigepro = "S" if configuracoes["coletaPrecos"]["agenda"]["ativar"] else "N"
valor_hora_cron_job_retorno_coleta_preco_sigepro = configuracoes["coletaPrecos"]["agenda"]["hora"]
valor_minuto_cron_job_retorno_coleto_preco_sigepro = configuracoes["coletaPrecos"]["agenda"]["minuto"]
valor_dia_semana_cron_job_retorno_coleto_preco_sigepro = configuracoes["coletaPrecos"]["agenda"]["diaDaSemana"]

cliente_linux.executar_comando(fr'docker login gitlab.microuniverso.com.br:5050 -u {usuario_registro_docker} -p {senha_registro_docker}', disparar_excecao_se_retorno_nao_zero=False)


cliente_linux.executar_comando(fr"sed -i 's,\$IMAGEM,{imagem_enterprise},g' /home/{usuario}/enterprise/docker-compose.yml")

cliente_linux.executar_comando(f"sed -i 's,\$PORTA,{porta_enterprise},g' /home/{usuario}/enterprise/docker-compose.yml")

cliente_linux.executar_comando(f"sed -i 's,\$MICROKAFKA_HOST,{microkafka_host},g' /home/{usuario}/enterprise/docker-compose.yml")

cliente_linux.copiar_arquivo(fr'{diretorio_scripts_implantacao}\enterprise\config.env' , f'/home/{usuario}/enterprise/config.env')

cliente_linux.executar_comando(fr"sed -i 's,\$AUTENTICACAO_USUARIO,REST_LEGADO,g' /home/{usuario}/enterprise/config.env")
host_banco_ajustado = host_banco.replace("\\","\\\\")
cliente_linux.executar_comando(fr"sed -i 's,\$DB_HOST,{host_banco_ajustado},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$DB_NAME,{nome_banco},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$DB_PASSWORD,{senha_banco},g' /home/{usuario}/enterprise/config.env", echoar=False,descricao="Alterando senha do banco")
cliente_linux.executar_comando(fr"sed -i 's,\$DB_PORT,1433,g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$DB_USER,{usuario_banco},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$MU_DLL_REST_API_ADDRESS,{ip_host},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$MU_DLL_REST_API_PORT,{porta_mu_dll_rest},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$NEOCREDIT_ENVIO_PROCESSAMENTO_URL,{neocredit_envio_processamento_url},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$NEOCREDIT_TOKEN,{neocredit_token},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$REST_LEGADO_HOST,{ip_host},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$REST_LEGADO_PORTA,{porta_rest_legado},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$WEB_HOOK_URL,{neocredit_url_webhook},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$USANDO_SQLSERVER_2008,{sql_server_2008},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$ATIVAR_JOB_REPROCESSAMENTO_CUSTO_MEDIO_ONLINE,{ativar_reprocessamento_custo_medio_online},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$VALOR_HORA_CRON_JOB_REPROCESSAMENTO_CUSTO_MEDIO_ONLINE,{hora_reprocessamento_custo_medio_online},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$VALOR_MINUTO_CRON_JOB_REPROCESSAMENTO_CUSTO_MEDIO_ONLINE,{minuto_reprocessamento_custo_medio_online},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$ATIVAR_JOB_RETORNO_COLETA_PRECO_SIGEPRO,{ativar_job_retorno_coleta_preco_sigepro}, g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$VALOR_HORA_CRON_JOB_RETORNO_COLETA_PRECO_SIGEPRO,{valor_hora_cron_job_retorno_coleta_preco_sigepro},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$VALOR_MINUTO_CRON_JOB_RETORNO_COLETA_PRECO_SIGEPRO,{valor_minuto_cron_job_retorno_coleto_preco_sigepro},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$VALOR_DIA_SEMANA_CRON_JOB_RETORNO_COLETA_PRECO_SIGEPRO,{valor_dia_semana_cron_job_retorno_coleto_preco_sigepro},g' /home/{usuario}/enterprise/config.env")


cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/enterprise/docker-compose.yml down')    
cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/enterprise/docker-compose.yml pull')    
cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/enterprise/docker-compose.yml up -d')    

if not configurar_event_handler:
    cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/enterprise/docker-compose.yml rm -fs enterprise-event-handler')

exit(0)