. $PSScriptRoot\_echo.ps1
. $PSScriptRoot\configuracoesMicrouniversoWeb.ps1

function global:mu.clonarReleaseWeb() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    $usuario = $configuracoes.acessos.git.usuario
    $senha = $configuracoes.acessos.git.senha
    $referencia = $configuracoes.dadosRelease.referencia
    

    $url = "https://${usuario}:${senha}@gitlab.microuniverso.com.br/Microuniverso/MUFenix/ReleaseWeb.git"

    $diretorioRelaseWebInformado = $diretorioReleaseWeb

    $diretorioReleaseWebResolvido = if ($PSBoundParameters.ContainsKey("diretorioReleaseWeb") -and $null -ne $diretorioRelaseWebInformado) {$diretorioRelaseWebInformado} else {"c:\temp\ReleaseWeb"}

    $diretorioReleaseWebInformadoManualmente = $PSBoundParameters.ContainsKey("diretorioReleaseWeb") -and $null -ne $diretorioRelaseWebInformado

    if ($diretorioReleaseWebInformadoManualmente) {
        _echo "Diretorio ReleaseWeb $diretorioReleaseWebResolvido informado manualmente. Clone nao sera executado" warn
        return $diretorioReleaseWebResolvido
    }

    if ($configuracoes.dadosRelease.clonarRepositorio -eq $false) {
        _echo "Download do repositorio desativado via configuracao. Usando diretorio existente $diretorioReleaseWebResolvido" warn
        return $diretorioReleaseWebResolvido
    }

    $_ErrorActionPreference = $ErrorActionPreference

    $ErrorActionPreference = 'Continue'
    
    

    if (Test-Path $diretorioReleaseWebResolvido) {
        Remove-Item -Force -Recurse $diretorioReleaseWebResolvido
    }
    

    $tipoReferencia = if ($referencia -match "[0-9a-f]{40}") { "sha1"} else {"tagBranch"}

    if ($tipoReferencia -eq "tagBranch") {
        git clone -b $referencia --depth 1 $url  $diretorioReleaseWebResolvido | out-null
    } else {
        git clone -b master --depth 1 $url $diretorioReleaseWebResolvido | out-null
        git -C $diretorioReleaseWebResolvido fetch origin --depth 1 $referencia | out-null
        git -C $diretorioReleaseWebResolvido checkout $referencia | out-null
    }
    
    $ErrorActionPreference = $_ErrorActionPreference
    
    $diretorioReleaseWebResolvido

}

function global:mu.clonarReleaseWeb.test() {
    $enderecoYaml = "C:\microuniversoWeb\microuniversoWeb.yaml"
    $senha = "123"
    
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml $enderecoYaml -senha $senha

    mu.clonarReleaseWeb -configuracoes $configuracoes


}

function global:mu.obterTagOuSHA1ReleaseWeb() {
    param(
        $enderecoRepositorio
    )

    $_ErrorActionPreference = $ErrorActionPreference
    
    $ErrorActionPreference = 'Continue'

    $tag = git -C $enderecoRepositorio tag --points-at HEAD
    $branch = git -C $enderecoRepositorio branch --show-current
    $sha1 = git -C $enderecoRepositorio rev-parse HEAD

    $ErrorActionPreference = $_ErrorActionPreference

    if ([string]::IsNullOrEmpty($tag) -and [string]::IsNullOrEmpty($branch)) {
        $sha1
    } elseif (![string]::IsNullOrEmpty($tag)) {
        $tag
    } else {
        $branch
    }



    
}

function global:mu.obterTagOuSHA1ReleaseWeb.test() {
    
    $diretorioReleaseWeb = "C:\temp\ReleaseWeb"

    $referencia = mu.obterTagOuSHA1ReleaseWeb -enderecoRepositorio $diretorioReleaseWeb

    _echo "referncia: $referencia"

}