. $PSScriptRoot\criptografiaSenha.ps1

function global:mu.obterStringConexao() {
    param(
        $configuracoes,

        # DOT_NET ou VFP
        [Parameter(
            Mandatory = $true
        )]

        $tipoConexao
    )

    $enderecoHost = $configuracoes.acessos.banco.host
    $usuario = $configuracoes.acessos.banco.usuario
    $senha = mu.descriptografarSenha($configuracoes.acessos.banco.senha)
    $nomeBanco = $configuracoes.acessos.banco.nomeBanco

    $stringConexao = if ($tipoConexao -eq "DOT_NET") {
        "SERVER=$enderecoHost;DATABASE=$nomeBanco;UID=$usuario;PWD=$senha;"
    } elseif ($tipoConexao -eq "VFP") {
        "DRIVER=SQL Server;SERVER=$enderecoHost;DATABASE=$nomeBanco;UID=$usuario;PWD=$senha;"
    } else {
        ""
    }

    return $stringConexao
}