const { argv } = require('yargs')
const { encryptFileRSA_AES } = require('./encryptUtils')
const fs = require('fs')

async function main() {
    const publicKeyPath = argv['publicKeyPath']
    const source = argv['source']
    const destination = argv['destination']

    const publicKey = fs.readFileSync(publicKeyPath,{encoding: 'utf8'})

    await encryptFileRSA_AES({
        filePathPlainText: source,
        filePathEncrypted: destination,
        publicKey: publicKey
    })
}

main().then(() => process.exit(0)).catch(error => {
    console.error(error)
    process.exit(1)
})