. $PSScriptRoot\configuracoesMicrouniversoWeb.ps1
. $PSScriptRoot\pararProcessosEServicosNecessarios.ps1

function global:_mu.copiarServico() {
    param(
        $nomeServico,
        $configuracoes,
        $diretorioReleaseWeb
    )

    _echo "Copiando $nomeServico"

    $servico = $configuracoes.servicos."$nomeServico"

    if (!($servico.configurar)) {
        _echo "Servico $nomeServico nao sera configurado. Desativado via configuracao" warn
        return
    }

    $diretorioInstalacao = if ("diretorioRelativoInstalacao" -in $servico.psobject.properties.name) {
        "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($servico.diretorioRelativoInstalacao)"
    } elseif ("diretorioAbsolutoInstalacao" -in $servico.psobject.properties.name) {
        $servico.diretorioAbsolutoInstalacao
    } else {
        throw "Diretorio de instalacao nao informado para $nomeServico"
    }

    if (!(test-path "$diretorioInstalacao")) {
        New-Item -Path "$diretorioInstalacao" -ItemType Directory
    }

    $diretorioNoReleaseWeb = if ("diretorioRelativoReleaseWeb" -in $servico.psobject.properties.name) {
        "$diretorioReleaseWeb\$($servico.diretorioRelativoReleaseWeb)"
    } else {
        $null
    }

    if ($null -eq $diretorioNoReleaseWeb) {
        _echo "Diretorio no release web nao informado para servico $nomeServico. Nada sera copiado"
        return
    }

    
    Copy-Item "$diretorioNoReleaseWeb\*" "$diretorioInstalacao" -Recurse -force
    
}
function global:mu.copiarServicosParaDiretorioInstalacao() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    if (-not (_mu.necessarioReiniciarIIS $configuracoes)) {
        _echo "Nenhum servico que usa o IIS sera configurado. Servicos nao serao copiados" warn
        return
    }
    
    $diretorioBaseInstalacao = $configuracoes.enderecos.diretorioBaseInstalacao

    if (!(Test-Path $diretorioReleaseWeb)) {
        throw "Diretorio do release web nao encontrado"
    }

    if (!(test-path $diretorioBaseInstalacao)) {
        New-Item -Path $diretorioBaseInstalacao -ItemType Directory
    }

    _mu.copiarServico "rest" $configuracoes $diretorioReleaseWeb
    _mu.copiarServico "authServer" $configuracoes $diretorioReleaseWeb
    _mu.copiarServico "resourceServer" $configuracoes $diretorioReleaseWeb
    _mu.copiarServico "segurancaWeb" $configuracoes $diretorioReleaseWeb
    _mu.copiarServico "imagensProdutos" $configuracoes $diretorioReleaseWeb
    _mu.copiarServico "orcamentoWeb" $configuracoes $diretorioReleaseWeb
    _mu.copiarServico "carrinhoDeCompra" $configuracoes $diretorioReleaseWeb
    _mu.copiarServico "financeiro" $configuracoes $diretorioReleaseWeb
    _mu.copiarServico "liberarPendencia" $configuracoes $diretorioReleaseWeb
    _mu.copiarServico "ordemDeCompra" $configuracoes $diretorioReleaseWeb
    _mu.copiarServico "wcf" $configuracoes $diretorioReleaseWeb
    _mu.copiarServico "fenixWrapper" $configuracoes $diretorioReleaseWeb
}