. $PSScriptRoot\configuracoesMicrouniversoWeb.ps1
. $PSScriptRoot\_echo.ps1

function global:mu.whatsappBot.dados() {
    
    return @{
        repositorioLocalWhatsappBot = "C:\microuniversoWeb\whatsappBot\whatsappBot"
    }
}

function global:mu.whatsappBot.clonarRepositorio() {
    param(
        $configuracoes
    )

    $usuario = "oauth2"
    $senha = "glpat-NZMzGRjxeXz13LyspkPE"
    $referencia = "$($configuracoes.whatsappBot.versao)"

    $url = "https://${usuario}:${senha}@gitlab.microuniverso.com.br/microuniverso/MUFenix/WhatsappBot.git"

    $diretorioRepositorioLocal = $(mu.whatsappBot.dados).repositorioLocalWhatsappBot

    if (test-path $diretorioRepositorioLocal) {
        remove-item -force -recurse $diretorioRepositorioLocal
    }

    $_ErrorActionPreference = $ErrorActionPreference

    $ErrorActionPreference = 'Continue'

    git clone -b $referencia --depth 1 $url $diretorioRepositorioLocal | out-null

    $ErrorActionPreference = $_ErrorActionPreference
}

function global:mu.whatsappBot.clonarRepositorio.test{
    

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml "$PSScriptRoot\arquivos-yml-teste\microuniversoWeb-whatsappBot.yaml"

    mu.whatsappBot.clonarRepositorio -configuracoes $configuracoes
}



function global:mu.whatsappBot.configurarVariaveisAmbiente {
    param(
        $configuracoes
    )
    $_ErrorActionPreference = $ErrorActionPreference

    $ErrorActionPreference = 'Continue'

    $arquivoConfigEnv = "$($(mu.whatsappBot.dados).repositorioLocalWhatsappBot)\config.env"

    if (test-path $arquivoConfigEnv) {
        remove-item $arquivoConfigEnv
    }

    $conteudo = "
        MICROKAFKA_HOST=$($configuracoes.whatsappBot.microkafka.host)
        MICROKAFKA_PORT=$($configuracoes.whatsappBot.microkafka.porta)
        ENTERPRISE_HOST=$($configuracoes.whatsappBot.apiEnterprise.host)
        ENTERPRISE_PORT=$($configuracoes.whatsappBot.apiEnterprise.porta)
        ENTERPRISE_USER=$($configuracoes.whatsappBot.apiEnterprise.usuario)
        ENTERPRISE_PASSWORD=$($configuracoes.whatsappBot.apiEnterprise.senha)
        NAVEGADOR_PADRAO=$($configuracoes.whatsappBot.navegador)
        DIRETORIO_LOGS=$($configuracoes.whatsappBot.diretorioLogs)
        DIRETORIO_ARQUIVOS=$($configuracoes.whatsappBot.diretorioArquivos)
        INTERFACE=$($configuracoes.whatsappBot.interface)
        IDIOMA=PT
    "
    
    add-content $arquivoConfigEnv ($conteudo -replace "\n\s+","`n")
    
    $ErrorActionPreference = $_ErrorActionPreference
}

function global:mu.whatsappBot.configurarVariaveisAmbiente.test() {
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml "$PSScriptRoot\arquivos-yml-teste\microuniversoWeb-whatsappBot.yaml"

    mu.whatsappBot.configurarVariaveisAmbiente -configuracoes $configuracoes
}

function global:mu.whatsappBot.criarAtalho() {

    param(
        $configuracoes
    )

    $shortcutPath = "$($(mu.whatsappBot.dados).repositorioLocalWhatsappBot)\WhatsappBot.lnk"

    if (test-path $shortcutPath) {
        remove-item -force $shortcutPath
    }
    
    
    $pythonExe = "$($(mu.whatsappBot.dados).repositorioLocalWhatsappBot)\venv\Scripts\python.exe"

    $enderecoRunGuiPy = "$($(mu.whatsappBot.dados).repositorioLocalWhatsappBot)\run_gui.py" 

    $startInPath = "$($(mu.whatsappBot.dados).repositorioLocalWhatsappBot)"
    
    $wsShell = New-Object -comObject WScript.Shell
    $Shortcut = $wsShell.CreateShortcut($shortcutPath)
    $Shortcut.TargetPath = "$pythonExe"
    $Shortcut.Arguments = "$enderecoRunGuiPy"
    $Shortcut.WorkingDirectory = "$startInPath"
    $Shortcut.Save()
}

function global:mu.whatsappBot.criarAtalho.test() {
    (mu.whatsappBot.criarAtalho)
}

function global:mu.whatsappBot.executarWhatsappBot() {
    param(
        $configuracoes
    )

    $pythonPath = "$($(mu.whatsappBot.dados).repositorioLocalWhatsappBot)\venv\Scripts\python.exe"

    $repositorioLocalWhatsappBot = $(mu.whatsappBot.dados).repositorioLocalWhatsappBot
    #$pythonPath = "$configuracoes\python\python.exe"
    $whatsappBotGui = "$repositorioLocalWhatsappBot\run_gui.py"
    Start-Process -WorkingDirectory $repositorioLocalWhatsappBot -FilePath $pythonPath -ArgumentList """$whatsappBotGui""" -NoNewWindow
}

function global:mu.whatsappBot.executarWhatsappBot.test() {
    

    (mu.whatsappBot.executarWhatsappBot)
}

function global:mu.whatsappBot.configurarVenv() {

    param(
        $configuracoes
    )

    $diretorioPython = "$($configuracoes.enderecos.diretorioBaseInstalacao)\python"

    $python = "$diretorioPython\python.exe"

    $repositorioLocalWhatsappBot = $(mu.whatsappBot.dados).repositorioLocalWhatsappBot

    $venvPath = "$repositorioLocalWhatsappBot\venv"

    $pipVenv = "$venvPath\Scripts\pip3.exe"

    . $python -m virtualenv $venvPath

    $requirementsTxt = "$repositorioLocalWhatsappBot\requirements.txt"

    $_ErrorActionPreference = $ErrorActionPreference

    $ErrorActionPreference = 'Continue'

    _echo "Instalando pacotes"

    & $pipVenv install -r $requirementsTxt

    $ErrorActionPreference = $_ErrorActionPreference

}

function global:mu.whatsappBot.configurarWhatsappBot() {
    param(
        $configuracoes
    )

    if ($configuracoes.whatsappBot.configurar -eq $false) {
        _echo "Configuracao do whatsappBot desativada via arquivo de configuracao" warn
        return
    }
    _echo "Clonando Repositorio WhatsappBot"
    mu.whatsappBot.clonarRepositorio -configuracoes $configuracoes

    _echo "Configurando venv e instalando pacotes"
    mu.whatsappBot.configurarVenv -configuracoes $configuracoes

    _echo "Configurando WhatsappBot"
    mu.whatsappBot.configurarVariaveisAmbiente -configuracoes $configuracoes

    _echo "Criando atalho"
    mu.whatsappBot.criarAtalho -configuracoes $configuracoes

    _echo "Executando WhatsappBot"
    mu.whatsappBot.executarWhatsappBot -configuracoes $configuracoes

}

function global:mu.whatsappBot.configurarWhatsappBot.test() {
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml "$PSScriptRoot\arquivos-yml-teste\microuniversoWeb-whatsappBot.yaml"

    mu.whatsappBot.configurarWhatsappBot -configuracoes $configuracoes
}


