. $PSScriptRoot\obterBuildTools.ps1
. $PSScriptRoot\obterStringConexao.ps1

function global:_mu.editarArquivoConfigWcf(){
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    $buildTools = mu.obterBuildTools $configuracoes $diretorioReleaseWeb
    $diretorioBaseInstalacao = $configuracoes.enderecos.diretorioBaseInstalacao
    $diretorioWcf = "$diretorioBaseInstalacao\$($configuracoes.servicos.wcf.diretorioRelativoInstalacao)"

    $enderecoDllFenix = "$diretorioBaseInstalacao\dll\fenix.dll"

    & $buildTools changexmldata $diretorioWcf\MicroUniverso.Venda.Orcamento.Host.Console.exe.config /configuration/fenixConfig/add[@key="'"connectionString"'"]/@value "$(mu.obterStringConexao $configuracoes VFP)"

    & $buildTools changexmldata $diretorioWcf\MicroUniverso.Venda.Orcamento.Host.Console.exe.config /configuration/fenixConfig/add[@key="'"connectionStringFenixWeb"'"]/@value "$(mu.obterStringConexao $configuracoes DOT_NET)"

    & $buildTools changexmldata $diretorioWcf\MicroUniverso.Venda.Orcamento.Host.Console.exe.config /configuration/fenixConfig/add[@key="'"connectionStringFenixWeb"'"]/@value "$(mu.obterStringConexao $configuracoes DOT_NET)"

    & $buildTools changexmldata $diretorioWcf\MicroUniverso.Venda.Orcamento.Host.Console.exe.config /configuration/fenixConfig/add[@key="'"fenixDllPath"'"]/@value $enderecoDllFenix

    & $buildTools changexmldata $diretorioWcf\MicroUniverso.Venda.Orcamento.Host.Console.exe.config /configuration/connectionStrings/add[@name="'"elmahConexao"'"]/@connectionString "$(mu.obterStringConexao $configuracoes DOT_NET)"
}

function global:_mu.configurarWcfOrcamentoWeb (){
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    if ($configuracoes.servicos.orcamentoWeb.configurar -eq $false) {
        _echo "orcamentoWeb desativado via configuracao. WCF nao sera configurado"
        return
    }

    $buildTools = mu.obterBuildTools $configuracoes $diretorioReleaseWeb
    $diretorioOrcamentoWeb = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.orcamentoWeb.diretorioRelativoInstalacao)"
    $diretorioWcf = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.wcf.diretorioRelativoInstalacao)"

    $ativarWcf = (-not $configuracoes.servicos.fenixWrapper.habilitar).ToString().ToLower()

    & $buildTools changexmldata $diretorioOrcamentoWeb\web.config /configuration/hostManager/add[@key="'"wcf"'"]/@value "$ativarWcf"

    & $buildTools changexmldata $diretorioOrcamentoWeb\web.config /configuration/hostManager/add[@key="'"path"'"]/@value "$($diretorioWcf)\MicroUniverso.Venda.Orcamento.Host.Console.exe"

    & $buildTools changexmldata $diretorioOrcamentoWeb\web.config /configuration/hostManager/add[@key="'"configFile"'"]/@value "$($diretorioWcf)\MicroUniverso.Venda.Orcamento.Host.Console.exe.config"

    & $buildTools changexmldata $diretorioOrcamentoWeb\web.config /configuration/hostManager/add[@key="'"timeout"'"]/@value "180"
}

function global:_mu.configurarWcfFinanceiro() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    if ($configuracoes.servicos.financeiro.configurar -eq $false) {
        _echo "financeiro desativado via configuracao. WCF nao sera configurado"
        return
    }

    $buildTools = mu.obterBuildTools $configuracoes $diretorioReleaseWeb
    $diretorioFinanceiro = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.financeiro.diretorioRelativoInstalacao)"

    & $buildTools changexmldata $diretorioFinanceiro\MicroUniverso.Financeiro.Web\web.config /configuration/hostManager/add[@key="'"wcf"'"]/@value "false"

    & $buildTools changexmldata $diretorioFinanceiro\MicroUniverso.Financeiro.Web\web.config /configuration/hostManager/add[@key="'"path"'"]/@value ""

    & $buildTools changexmldata $diretorioFinanceiro\MicroUniverso.Financeiro.Web\web.config  /configuration/hostManager/add[@key="'"configFile"'"]/@value ""

}

function global:_mu.configurarWcfRest() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    if ($configuracoes.servicos.rest.configurar -eq $false) {
        _echo "rest desativado via configuracao. WCF nao sera configurado"
        return
    }

    $buildTools = mu.obterBuildTools $configuracoes $diretorioReleaseWeb
    $diretorioRest = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.rest.diretorioRelativoInstalacao)"

    & $buildTools changexmldata $diretorioRest\web.config /configuration/hostManager/add[@key="'"wcf"'"]/@value "false"

    & $buildTools changexmldata $diretorioRest\web.config /configuration/hostManager/add[@key="'"path"'"]/@value ""

    & $buildTools changexmldata $diretorioRest\web.config  /configuration/hostManager/add[@key="'"configFile"'"]/@value ""
}

function global:_mu.configurarWcfSeguranca() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    if ($configuracoes.servicos.segurancaWeb.configurar -eq $false) {
        _echo "segurancaWeb desativado via configuracao. WCF nao sera configurado"
        return
    }

    $buildTools = mu.obterBuildTools $configuracoes $diretorioReleaseWeb
    $diretorioSeguranca = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.segurancaWeb.diretorioRelativoInstalacao)"

    & $buildTools changexmldata $diretorioSeguranca\web.config /configuration/hostManager/add[@key="'"wcf"'"]/@value "false"

    & $buildTools changexmldata $diretorioSeguranca\web.config /configuration/hostManager/add[@key="'"path"'"]/@value ""

    & $buildTools changexmldata $diretorioSeguranca\web.config  /configuration/hostManager/add[@key="'"configFile"'"]/@value ""
}

function global:_mu.configurarWcfAuthServer() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    if ($configuracoes.servicos.authServer.configurar -eq $false) {
        _echo "authServer desativado via configuracao. WCF nao sera configurado"
        return
    }

    $buildTools = mu.obterBuildTools $configuracoes $diretorioReleaseWeb
    $diretorioAuthServer = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.segurancaWeb.diretorioRelativoInstalacao)"

    & $buildTools changexmldata $diretorioAuthServer\web.config /configuration/hostManager/add[@key="'"wcf"'"]/@value "false"

    & $buildTools changexmldata $diretorioAuthServer\web.config /configuration/hostManager/add[@key="'"path"'"]/@value ""

    & $buildTools changexmldata $diretorioAuthServer\web.config  /configuration/hostManager/add[@key="'"configFile"'"]/@value ""
}

function global:_mu.configurarWcfResourceServer() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    if ($configuracoes.servicos.resourceServer.configurar -eq $false) {
        _echo "resourceServer desativado via configuracao. WCF nao sera configurado"
        return
    }

    $buildTools = mu.obterBuildTools $configuracoes $diretorioReleaseWeb
    $diretorioResourceServer = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.resourceServer.diretorioRelativoInstalacao)"

    & $buildTools changexmldata $diretorioResourceServer\web.config /configuration/hostManager/add[@key="'"wcf"'"]/@value "false"

    & $buildTools changexmldata $diretorioResourceServer\web.config /configuration/hostManager/add[@key="'"path"'"]/@value ""

    & $buildTools changexmldata $diretorioResourceServer\web.config  /configuration/hostManager/add[@key="'"configFile"'"]/@value ""
}

function global:mu.configurarWcf() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    TASKKILL /F /FI "IMAGENAME eq MicroUniverso.Venda.Orcamento.Host.Console.exe"

    # iisreset /stop

    _mu.editarArquivoConfigWcf $configuracoes $diretorioReleaseWeb

    _mu.configurarWcfOrcamentoWeb $configuracoes $diretorioReleaseWeb

    _mu.configurarWcfFinanceiro $configuracoes $diretorioReleaseWeb
    
    _mu.configurarWcfRest $configuracoes $diretorioReleaseWeb

    _mu.configurarWcfSeguranca $configuracoes $diretorioReleaseWeb

    _mu.configurarWcfAuthServer $configuracoes $diretorioReleaseWeb
    
    _mu.configurarWcfResourceServer $configuracoes $diretorioReleaseWeb
    
}

function mu.configurarWcf.test() {
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter C:\mu-scripts\microuniversoWeb.yaml

    mu.configurarWcf $configuracoes
}

# mu.configurarWcf.test