. $PSScriptRoot\configuracoesMicrouniversoWeb.ps1
. $PSScriptRoot\obterBuildTools.ps1
. $PSScriptRoot\_echo.ps1

function global:mu.configurarOrcamentoWebParaLoadBalancerAWS.appcmd() {
    return "C:\\windows\\system32\\inetsrv\\appcmd.exe"
}

function global:mu.configurarOrcamentoWebParaLoadBalancerAWS.buildtools() {
    return "$psscriptroot\buildtools\MicroUniverso.BuildTools.exe"
}

function global:mu.configurarOrcamentoWebParaLoadBalancerAWS.dadosTeste() {
    return @{
        arquivoYamlTeste = "C:\temp\microuniversoWeb-lb.yaml"

    }
}

function global:mu.configurarOrcamentoWebParaLoadBalancerAWS.excluirSiteDefaultPorta80 () {
    $nomeSite = "Default Web Site"

    $appcmd = (mu.configurarOrcamentoWebParaLoadBalancerAWS.appcmd)

    & $appcmd delete site $nomeSite
}

function global:mu.configurarOrcamentoWebParaLoadBalancerAWS.excluirSiteDefaultPorta80.test() {
    (mu.configurarOrcamentoWebParaLoadBalancerAWS.excluirSiteDefaultPorta80)
}

function global:mu.configurarOrcamentoWebParaLoadBalancerAWS.configurarBindings() {
    param(
        $configuracoes
    )

    $appcmd = (mu.configurarOrcamentoWebParaLoadBalancerAWS.appcmd)

    $nomeSiteOrcamentoWeb = $($configuracoes.servicos.orcamentoWeb.nomeSite)
    $enderecoDnsOrcamentoWeb = $($configuracoes.orcamentoWebLoadBalancerAWS.enderecoDnsOrcamentoWeb)
    
    & $appcmd set site /site.name:$nomeSiteOrcamentoWeb /-bindings:"http:/*:*:"
    & $appcmd set site /site.name:$nomeSiteOrcamentoWeb /+"bindings.[protocol='http',bindingInformation='*:80:$enderecoDnsOrcamentoWeb']"

    $nomeSiteRest = $($configuracoes.servicos.rest.nomeSite)
    $enderecoDnsRest = $($configuracoes.orcamentoWebLoadBalancerAWS.enderecoDnsRest)

    & $appcmd set site /site.name:$nomeSiteRest /-bindings:"http:/*:*:"
    & $appcmd set site /site.name:$nomeSiteRest /+"bindings.[protocol='http',bindingInformation='*:80:$enderecoDnsRest']"

    $nomeSiteSegurancaWeb = $($configuracoes.servicos.segurancaWeb.nomeSite)
    $enderecoDnsSegurancaWeb = $($configuracoes.orcamentoWebLoadBalancerAWS.enderecoDnsSegurancaWeb)

    & $appcmd set site /site.name:$nomeSiteSegurancaWeb /-bindings:"http:/*:*:"
    & $appcmd set site /site.name:$nomeSiteSegurancaWeb /+"bindings.[protocol='http',bindingInformation='*:80:$enderecoDnsSegurancaWeb']"
}

function global:mu.configurarOrcamentoWebParaLoadBalancerAWS.ajustarArquivosConfig() {
    param(
        $configuracoes
    )

    $webConfigOrcamentoWeb = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.orcamentoWeb.diretorioRelativoInstalacao)\Web.config"
    $webConfigSegurancaWeb = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.segurancaWeb.diretorioRelativoInstalacao)\Web.config"
    $webConfigRest = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.rest.diretorioRelativoInstalacao)\Web.config"
    
    $enderecoDnsRest = "http://$($configuracoes.orcamentoWebLoadBalancerAWS.enderecoDnsRest)"
    $awsKey = $($configuracoes.orcamentoWebLoadBalancerAWS.awsKey)
    $awsSecret = $($configuracoes.orcamentoWebLoadBalancerAWS.awsSecret)
    $s3Bucket = $($configuracoes.orcamentoWebLoadBalancerAWS.s3Imagens.bucket)
    $s3Regiao = $($configuracoes.orcamentoWebLoadBalancerAWS.s3Imagens.regiao)
    
    $buildTools = (mu.configurarOrcamentoWebParaLoadBalancerAWS.buildtools)
    
    & $buildTools changexmldata $webConfigOrcamentoWeb /configuration/microAuth/add[@key="'"restApiBaseAddress"'"]/@value $enderecoDnsRest

    & $buildTools changexmldata $webConfigOrcamentoWeb /configuration/storages/s3/add[@key="'"enabled"'"]/@value "true"
    & $buildTools changexmldata $webConfigOrcamentoWeb /configuration/storages/s3/add[@key="'"key"'"]/@value $awsKey
    & $buildTools changexmldata $webConfigOrcamentoWeb /configuration/storages/s3/add[@key="'"secret"'"]/@value $awsSecret
    & $buildTools changexmldata $webConfigOrcamentoWeb /configuration/storages/s3/add[@key="'"bucketName"'"]/@value $s3Bucket
    & $buildTools changexmldata $webConfigOrcamentoWeb /configuration/storages/s3/add[@key="'"region"'"]/@value $s3Regiao

    & $buildTools changexmldata $webConfigSegurancaWeb /configuration/storages/s3/add[@key="'"enabled"'"]/@value "true"
    & $buildTools changexmldata $webConfigSegurancaWeb /configuration/storages/s3/add[@key="'"key"'"]/@value $awsKey
    & $buildTools changexmldata $webConfigSegurancaWeb /configuration/storages/s3/add[@key="'"secret"'"]/@value $awsSecret
    & $buildTools changexmldata $webConfigSegurancaWeb /configuration/storages/s3/add[@key="'"bucketName"'"]/@value $s3Bucket
    & $buildTools changexmldata $webConfigSegurancaWeb /configuration/storages/s3/add[@key="'"region"'"]/@value $s3Regiao
    
    & $buildTools changexmldata $webConfigRest /configuration/fenixConfig/add[@key="'"executandoEmLoadBalancer"'"]/@value "true"
}

function global:mu.configurarOrcamentoWebParaLoadBalancerAWS.ajustarArquivosConfig.test() {
    $arquivoYamlTeste = (mu.configurarOrcamentoWebParaLoadBalancerAWS.dadosTeste).arquivoYamlTeste

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml $arquivoYamlTeste

    mu.configurarOrcamentoWebParaLoadBalancerAWS.ajustarArquivosConfig $configuracoes
}

function global:mu.configurarOrcamentoWebParaLoadBalancerAWS.configurarBindings.test() {
    $arquivoYamlTeste = (mu.configurarOrcamentoWebParaLoadBalancerAWS.dadosTeste).arquivoYamlTeste

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml $arquivoYamlTeste

    mu.configurarOrcamentoWebParaLoadBalancerAWS.configurarBindings $configuracoes
}

function global:mu.configurarOrcamentoWebParaLoadBalancerAWS.executar() {
    param(
        $configuracoes
    )

    if ($configuracoes.orcamentoWebLoadBalancerAWS.configurar -eq $false) {
        _echo "Vendas LB AWS - Desativado via configuracao"
        return
    }

    _echo "Vendas LB AWS - Excluindo site padrao da porta 80"
    (mu.configurarOrcamentoWebParaLoadBalancerAWS.excluirSiteDefaultPorta80)

    _echo "Vendas LB AWS - Configurando bindings"
    mu.configurarOrcamentoWebParaLoadBalancerAWS.configurarBindings $configuracoes

    _echo "Vendas LB AWS - Ajustando arquivos config" 
    mu.configurarOrcamentoWebParaLoadBalancerAWS.ajustarArquivosConfig $configuracoes


}