. $PSScriptRoot\_echo.ps1

function global:mu.monitorWMS.clonarRepositorioRelease() {
    param(
        $configuracoes
    )

    $usuario = "oauth2"
    $senha = "glpat-ojWVRhdXgwxMxtJYRHvs"
    $referencia = $configuracoes.monitorWMS.referencia

    $url = "https://${usuario}:${senha}@gitlab.microuniverso.com.br/Microuniverso/MUFenix/MonitorIntegracaoWMSRelease.git"

    $diretorioClone = "c:\temp\MonitorIntegracaoWMSRelease"

    if (test-path $diretorioClone) {
        remove-item -force -recurse $diretorioClone
    }

    $_ErrorActionPreference = $ErrorActionPreference

    $ErrorActionPreference = 'Continue'

    git clone -b $referencia --depth 1 $url $diretorioClone | out-null

    $ErrorActionPreference = $_ErrorActionPreference
}

function global:mu.monitorWMS.configurarArquivoConfig() {
    param(
        $configuracoes
    )

    $scriptConfigurarArquivoConfig = "C:\temp\MonitorIntegracaoWMSRelease\configurarArquivoConfig.ps1"
    
    $arquivoConfig = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.monitorWMS.diretorioInstalacao)\MicroUniverso.MonitorIntegracaoWMS.exe.config" 

    . $scriptConfigurarArquivoConfig `
        -wmsDbHost $configuracoes.monitorWMS.banco.host `
        -wmsDbUsuario $configuracoes.monitorWMS.banco.usuario `
        -wmsDbSenha $configuracoes.monitorWMS.banco.senha `
        -wmsDbNome $configuracoes.monitorWMS.banco.nome `
        -enderecoEndpointMU $configuracoes.monitorWMS.apiRest.endereco `
        -usuarioApi $configuracoes.monitorWMS.apiRest.usuario `
        -senhaApi $configuracoes.monitorWMS.apiRest.senha `
        -enderecoEndpointApiEnterpriseMU $configuracoes.monitorWMS.apiEnterprise.endereco `
        -arquivoConfig $arquivoConfig


}

function global:mu.monitorWMS.copiarParaDiretorioMicrouniversoWeb() {
    param(
        $configuracoes
    )

    $diretorioRelease = "C:\temp\MonitorIntegracaoWMSRelease\MonitorIntegracaoWMS"

    $diretorioNoMicrouniversoWeb = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.monitorWMS.diretorioInstalacao)"

    if (test-path $diretorioNoMicrouniversoWeb) {
        remove-item $diretorioNoMicrouniversoWeb -recurse
    }

    new-item -ItemType directory $diretorioNoMicrouniversoWeb

    copy-item $diretorioRelease\* $diretorioNoMicrouniversoWeb
}

function global:mu.monitorWMS.configurarESubirServico() {
    param(
        $configuracoes
    )

    $scriptConfigurarESubirServico = "C:\temp\MonitorIntegracaoWMSRelease\configurarESubirServico.ps1"
    $exePath = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.monitorWMS.diretorioInstalacao)\MicroUniverso.MonitorIntegracaoWMS.exe"

    . $scriptConfigurarESubirServico -exePath $exePath
}

function global:mu.monitorWMS.pararEExcluirServico {
    cmd /c sc stop MonitorIntegracaoWMS

    _echo "Aguardando programa MicroUniverso.MonitorIntegracaoWMS.exe ser finalizado para excluir servico"

    $contadorVerificacaoProcesso = 1

    while (@(Get-Process | where-object {$_.Name -eq "MicroUniverso.MonitorIntegracaoWMS"}).Length -ne 0) {
        Start-Sleep 2
        _echo "Esperando $contadorVerificacaoProcesso..."
        $contadorVerificacaoProcesso = $contadorVerificacaoProcesso + 1
        
    }

    cmd /c sc delete MonitorIntegracaoWMS

    _echo "Aguardando servico ser excluido para prosseguir"

    $contadorVerificacaoServico = 1

    while (@(get-service | where-object {$_.Name -eq "MonitorIntegracaoWMS"}).Length -ne 0) {
        Start-Sleep 2
        _echo "Esperando $contadorVerificacaoServico..."
        $contadorVerificacaoServico = $contadorVerificacaoServico + 1
        
    }


}

function global:mu.monitorWMS.configurarMonitorWMS() {
    param(
        $configuracoes
    )

    if ($configuracoes.monitorWMS.configurar -eq $false) {
        _echo "MonitorWMS desativado via configuracao"
        return
    }

    _echo "Parando e excluindo servico MonitorIntegracaoWMS"
    mu.monitorWMS.pararEExcluirServico

    _echo "Fazendo clone do release do MonitorWMS na branch/tag $($configuracoes.monitorWMS.referencia)"
    mu.monitorWMS.clonarRepositorioRelease $configuracoes

    _echo "Copiando MonitorWMS para microuniversoWeb"
    mu.monitorWMS.copiarParaDiretorioMicrouniversoWeb $configuracoes

    _echo "Configurando arquivo config do MonitorWMS"
    mu.monitorWMS.configurarArquivoConfig $configuracoes

    _echo "Configurando servico MonitorWMS (MonitorIntegracaoWMS)"
    mu.monitorWMS.configurarESubirServico $configuracoes
}