function global:mu.monitorFreteRapidoDocker.fazerLoginRegistroDocker {
    param(
        $configuracoes
    )

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    $enderecoRegistro = $configuracoes.monitorFreteRapido.imagem.nome.Split('/')[0]
    docker login $enderecoRegistro -u $configuracoes.monitorFreteRapido.imagem.usuario -p $configuracoes.monitorFreteRapido.imagem.senha 2> $null

    $ErrorActionPreference = $ErrorActionPreference_back
}

function global:mu.monitorFreteRapidoDocker.fazerLoginRegistroDocker.test {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $enderecoArquivoConfiguracao = "c:\temp\microuniversoWeb-monitor-frete-rapido-docker.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao
    mu.monitorFreteRapidoDocker.fazerLoginRegistroDocker $configuracoes
}

function global:mu.monitorFreteRapidoDocker.copiarEAjustarArquivosDeConfiguracao {
    $arquivoDockerComposeOrigem = "$PSScriptRoot\monitorFreteRapido\docker-compose-monitor-frete-rapido.yml"
    # $arquivoConfigOrigem = "$PSScriptRoot\enterprise\config.env"
    
    $diretorioMonitorFreteRapido = "$($configuracoes.enderecos.diretorioBaseInstalacao)\monitorFreteRapido"

    $arquivoDockerComposeDestino = "$diretorioMonitorFreteRapido\docker-compose-monitor-frete-rapido.yml"
    # $arquivoConfigDestino = "$diretorioEnterprise\config.env"

    $nomeImagemCompleta = "$($configuracoes.monitorFreteRapido.imagem.nome):$($configuracoes.monitorFreteRapido.imagem.versao)"

    if (!(Test-Path -Path $diretorioMonitorFreteRapido)) {
        New-Item -ItemType Directory $diretorioMonitorFreteRapido
    }

    # if (!(Test-Path -Path "$diretorioMonitorFreteRapido\logs")) {
    #     New-Item -ItemType Directory "$diretorioMonitorFreteRapido\logs"
    # }

    Copy-Item $arquivoDockerComposeOrigem $arquivoDockerComposeDestino

    # Copy-Item $arquivoConfigOrigem $arquivoConfigDestino

    (Get-Content -Path $arquivoDockerComposeDestino -Raw) -replace '\$IMAGEM',"$nomeImagemCompleta" | Set-Content -Path $arquivoDockerComposeDestino
    (Get-Content -Path $arquivoDockerComposeDestino -Raw) -replace '\$ENDERECO_KAFKA',"$($configuracoes.monitorFreteRapido.enderecoHostKafka):9093" | Set-Content -Path $arquivoDockerComposeDestino
    (Get-Content -Path $arquivoDockerComposeDestino -Raw) -replace '\$ENDERECO_API_FRETE_RAPIDO',"$($configuracoes.monitorFreteRapido.enderecoApi)" | Set-Content -Path $arquivoDockerComposeDestino

    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$DB_HOST',"$($configuracoes.acessos.banco.host)" | Set-Content -Path $arquivoConfigDestino
    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$DB_USER',"$($configuracoes.acessos.banco.usuario)" | Set-Content -Path $arquivoConfigDestino
    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$DB_PASSWORD',"$($configuracoes.acessos.banco.senha)" | Set-Content -Path $arquivoConfigDestino
    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$DB_NAME',"$($configuracoes.acessos.banco.nomeBanco)" | Set-Content -Path $arquivoConfigDestino
    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$DB_PORT',"1433" | Set-Content -Path $arquivoConfigDestino
    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$MU_DLL_REST_API_ADDRESS',"$($configuracoes.enderecos.ipHost)" | Set-Content -Path $arquivoConfigDestino
    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$MU_DLL_REST_API_PORT',"$($configuracoes.muDllRest.porta)" | Set-Content -Path $arquivoConfigDestino
    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$REST_LEGADO_HOST',"$($configuracoes.enderecos.ipHost)" | Set-Content -Path $arquivoConfigDestino
    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$REST_LEGADO_PORTA',"$($configuracoes.servicos.rest.porta)" | Set-Content -Path $arquivoConfigDestino
    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$AUTENTICACAO_USUARIO',"REST_LEGADO" | Set-Content -Path $arquivoConfigDestino
    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$USANDO_SQLSERVER_2008',"$($configuracoes.enterprise.usarSQLServer2008)" | Set-Content -Path $arquivoConfigDestino

    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$NEOCREDIT_ENVIO_PROCESSAMENTO_URL',"$($configuracoes.enterprise.neocredit.urlProcessamento)" | Set-Content -Path $arquivoConfigDestino
    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$NEOCREDIT_TOKEN',"$($configuracoes.enterprise.neocredit.tokenNeocredit)" | Set-Content -Path $arquivoConfigDestino
    # (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$WEB_HOOK_URL',"$($configuracoes.enterprise.neocredit.urlWebhook)" | Set-Content -Path $arquivoConfigDestino
    
}


function global:mu.monitorFreteRapidoDocker.copiarEAjustarArquivosDeConfiguracao.test {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $enderecoArquivoConfiguracao = "c:\temp\microuniversoWeb-monitor-frete-rapido-docker.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao
    mu.monitorFreteRapidoDocker.copiarEAjustarArquivosDeConfiguracao $configuracoes

}


function global:mu.monitorFreteRapidoDocker.baixarImagem {
    param(
        $configuracoes
    )

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    $arquivoCompose = "$($configuracoes.enderecos.diretorioBaseInstalacao)\monitorFreteRapido\docker-compose-monitor-frete-rapido.yml"
    docker-compose -f $arquivoCompose pull

    $ErrorActionPreference = $ErrorActionPreference_back
}

function global:mu.monitorFreteRapidoDocker.baixarImagem.test {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $enderecoArquivoConfiguracao = "c:\temp\microuniversoWeb-monitor-frete-rapido-docker.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao
    mu.monitorFreteRapidoDocker.baixarImagem $configuracoes
}

function global:mu.monitorFreteRapidoDocker.subirContainerMonitorFreteRapido {
    param(
        $configuracoes
    )

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    $arquivoCompose = "$($configuracoes.enderecos.diretorioBaseInstalacao)\monitorFreteRapido\docker-compose-monitor-frete-rapido.yml"
    docker-compose -f $arquivoCompose down
    docker-compose -f $arquivoCompose up -d

    

    $ErrorActionPreference = $ErrorActionPreference_back
}

function global:mu.monitorFreteRapidoDocker.subirContainerMonitorFreteRapido.test {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $enderecoArquivoConfiguracao = "c:\temp\microuniversoWeb-monitor-frete-rapido-docker.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao

    mu.monitorFreteRapidoDocker.subirContainerMonitorFreteRapido $configuracoes
}

function global:mu.monitorFreteRapidoDocker.configurarESubirFakeApi() {
    param(
        $configuracoes
    )

    if ($configuracoes.monitorFreteRapido.subirFakeApi -eq $false) {
        _echo "Fake api do frete rapido desativada via configuracao"
        return
    } else {
        _echo "Fake api do frete rapida sera configurada"
    }

    _echo "Parando fake api do frete rapido"

    $ErrorActionPreference_backup = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'
    $pidProcesso = (Get-NetTCPConnection -LocalPort 3333 -ErrorAction Ignore).OwningProcess

    Stop-Process $pidProcesso

    $ErrorActionPreference = $ErrorActionPreference_backup

    $diretorioFakeApiRelease = "C:\temp\MonitorFreteRapidoRelease\FreteRapidoFakeApi"
    $diretorioNoMicrouniversoWeb = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.monitorFreteRapido.diretorioInstalacao)\fakeApi"

    if (test-path $diretorioNoMicrouniversoWeb) {
        remove-item $diretorioNoMicrouniversoWeb -recurse
    }

    new-item -ItemType directory $diretorioNoMicrouniversoWeb

    copy-item $diretorioFakeApiRelease\* $diretorioNoMicrouniversoWeb

    Start-Process -FilePath "npm" -ArgumentList "install" -WorkingDirectory $diretorioNoMicrouniversoWeb -wait

    start-process -FilePath "npm" -ArgumentList "run dev" -WorkingDirectory $diretorioNoMicrouniversoWeb
}

function global:mu.monitorFreteRapidoDocker.configurarMonitorFreteRapido {
    param(
        $configuracoes
    )

    if ($configuracoes.monitorFreteRapido.configurar -eq $false) {
        _echo "Configuracao do MonitorFreteRapido desativada via configuracao" warn
        return
    }

    _echo "MonitorFreteRapido - Fazendo login no registry do docker"
    mu.monitorFreteRapidoDocker.fazerLoginRegistroDocker $configuracoes

    _echo "MonitorFreteRapido - Ajustando arquivos de configuracao"
    mu.monitorFreteRapidoDocker.copiarEAjustarArquivosDeConfiguracao $configuracoes

    _echo "MonitorFreteRapido - Baixando imagem"
    mu.monitorFreteRapidoDocker.baixarImagem $configuracoes

    _echo "MonitorFreteRapido - Subindo container"
    mu.monitorFreteRapidoDocker.subirContainerMonitorFreteRapido $configuracoes

    _echo "MonitorFreteRapido - Fake Api"
    mu.monitorFreteRapidoDocker.configurarESubirFakeApi $configuracoes
    
}

function global:mu.monitorFreteRapidoDocker.configurarMonitorFreteRapido.test {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $enderecoArquivoConfiguracao = "c:\temp\microuniversoWeb-monitor-frete-rapido-docker.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao

    mu.monitorFreteRapidoDocker.configurarMonitorFreteRapido $configuracoes
}

