function global:mu.monitorFreteRapido.clonarRepositorioRelease() {
    param(
        $configuracoes
    )

    $usuario = "oauth2"
    $senha = "glpat-Lr8Fu6jF7erS7xTzZitC"
    $referencia = $configuracoes.monitorFreteRapido.referencia

    $url = "https://${usuario}:${senha}@gitlab.microuniverso.com.br/microuniverso/MUFenix/MonitorFreteRapidoRelease.git"

    $diretorioClone = "c:\temp\monitorFreteRapidoRelease"

    if (test-path $diretorioClone) {
        remove-item -force -recurse $diretorioClone
    }

    $_ErrorActionPreference = $ErrorActionPreference

    $ErrorActionPreference = 'Continue'

    git clone -b $referencia --depth 1 $url $diretorioClone | out-null

    $ErrorActionPreference = $_ErrorActionPreference
}

function global:mu.monitorFreteRapido.copiarParaDiretorioMicrouniversoWeb() {
    param(
        $configuracoes
    )

    $diretorioRelease = "C:\temp\MonitorFreteRapidoRelease\MonitorFreteRapido"

    $diretorioNoMicrouniversoWeb = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.monitorFreteRapido.diretorioInstalacao)\monitorFreteRapido"

    if (test-path $diretorioNoMicrouniversoWeb) {
        remove-item $diretorioNoMicrouniversoWeb -recurse
    }

    new-item -ItemType directory $diretorioNoMicrouniversoWeb

    copy-item $diretorioRelease\* $diretorioNoMicrouniversoWeb -Recurse
}

function global:mu.monitorFreteRapido.configurarArquivoConfig() {
    param(
        $configuracoes
    )

    $scriptConfigurarArquivoConfig = "C:\temp\MonitorFreteRapidoRelease\configurarArquivoConfig.ps1"
    
    $arquivoConfig = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.monitorFreteRapido.diretorioInstalacao)\monitorFreteRapido\MonitorFreteRapido.dll.config" 

    $kafkaUrl = "$($configuracoes.monitorFreteRapido.enderecoHostKafka):9093"
    $enderecoApi = "$($configuracoes.monitorFreteRapido.enderecoApi)"

    . $scriptConfigurarArquivoConfig `
        -kafkaUrl $kafkaUrl `
        -enderecoApi $enderecoApi `
        -arquivoConfig $arquivoConfig


}

function global:mu.monitorFreteRapido.configurarESubirServico() {
    param(
        $configuracoes
    )

    $scriptConfigurarESubirServico = "C:\temp\MonitorFreteRapidoRelease\configurarESubirServico.ps1"
    $exePath = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.monitorFreteRapido.diretorioInstalacao)\monitorFreteRapido\MonitorFreteRapido.exe"

    . $scriptConfigurarESubirServico -exePath $exePath
}

function global:mu.monitorFreteRapido.configurarESubirFakeApi() {
    param(
        $configuracoes
    )

    if ($configuracoes.monitorFreteRapido.subirFakeApi -eq $false) {
        _echo "Fake api do frete rapido desativada via configuracao"
        return
    } else {
        _echo "Fake api do frete rapida sera configurada"
    }

    _echo "Parando fake api do frete rapido"

    $ErrorActionPreference_backup = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'
    $pidProcesso = (Get-NetTCPConnection -LocalPort 3333 -ErrorAction Ignore).OwningProcess

    Stop-Process $pidProcesso

    $ErrorActionPreference = $ErrorActionPreference_backup

    $diretorioFakeApiRelease = "C:\temp\MonitorFreteRapidoRelease\FreteRapidoFakeApi"
    $diretorioNoMicrouniversoWeb = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.monitorFreteRapido.diretorioInstalacao)\fakeApi"

    if (test-path $diretorioNoMicrouniversoWeb) {
        remove-item $diretorioNoMicrouniversoWeb -recurse
    }

    new-item -ItemType directory $diretorioNoMicrouniversoWeb

    copy-item $diretorioFakeApiRelease\* $diretorioNoMicrouniversoWeb

    Start-Process -FilePath "npm" -ArgumentList "install" -WorkingDirectory $diretorioNoMicrouniversoWeb -wait

    start-process -FilePath "npm" -ArgumentList "run dev" -WorkingDirectory $diretorioNoMicrouniversoWeb
}

function global:mu.monitorFreteRapido.configurarMonitorFreteRapido() {
    param(
        $configuracoes
    )

    if ($configuracoes.monitorFreteRapido.configurar -eq $false) {
        _echo "Monitor frete rapido desativado via configuracao"
        return
    }

    _echo "Parando processo MonitorFreteRapido.exe"
    TASKKILL /F /FI "IMAGENAME eq MonitorFreteRapido.exe"

    _echo "Fazendo clone do release do MonitorFreteRapido na branch/tag $($configuracoes.monitorFreteRapido.referencia)"
    mu.monitorFreteRapido.clonarRepositorioRelease $configuracoes

    _echo "Copiando MonitorFreteRapido para microuniversoWeb"
    mu.monitorFreteRapido.copiarParaDiretorioMicrouniversoWeb $configuracoes

    _echo "Configurando arquivo config do MonitorFreteRapido"
    mu.monitorFreteRapido.configurarArquivoConfig $configuracoes

    _echo "Inicando servico MonitorFreteRapido"
    mu.monitorFreteRapido.configurarESubirServico $configuracoes

    mu.monitorFreteRapido.configurarESubirFakeApi $configuracoes

}   

function global:mu.monitorFreteRapido.configurarMonitorFreteRapido.test() {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $arquivoConfiguracao = "C:\temp\microuniversoWeb-monitorFreteRapido.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $arquivoConfiguracao

    mu.monitorFreteRapido.configurarMonitorFreteRapido $configuracoes
}