. $PSScriptRoot\configurarMicrokafkaWindows.ps1

function global:mu.microkafka.fazerLoginRegistroDocker {
    param(
        $configuracoes
    )

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    docker login gitlab.microuniverso.com.br:5050 -u $configuracoes.microkafka.linux.imagem.usuario -p $configuracoes.microkafka.linux.imagem.senha 2> $null

    $ErrorActionPreference = $ErrorActionPreference_back
}

function global:mu.microkafka.baixarImagens() {
    param(
        $configuracoes
    )

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    $arquivoCompose = "$($configuracoes.enderecos.diretorioBaseInstalacao)\microkafka\docker-compose-microkafka.yml"

    docker-compose -f $arquivoCompose pull

    $ErrorActionPreference = $ErrorActionPreference_back
}

function global:mu.microkafka.baixarImagens.test() {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $arquivoConfiguracao = "C:\temp\microuniversoWeb-microkafka.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $arquivoConfiguracao

    mu.microkafka.baixarImagens $configuracoes
}


function global:mu.microkafka.copiarEAjustarArquivosDeConfiguracao() {
    param(
        $configuracoes
    )

    $diretorioMicrokafka = "$($configuracoes.enderecos.diretorioBaseInstalacao)\microkafka"

    if (!(test-path $diretorioMicrokafka)) {
        new-item -ItemType Directory $diretorioMicrokafka
    }

    $arquivoDockerComposeOrigem = "$PSScriptRoot\microkafka\docker-compose-microkafka.yml"
    $arquivoDockerComposeDestino = "$diretorioMicrokafka\docker-compose-microkafka.yml"

    copy-item $arquivoDockerComposeOrigem $arquivoDockerComposeDestino

    $tagMicrokafka = $configuracoes.microkafka.versaoMicrokafka
    $tagConfigurarMicrokafka = $configuracoes.microkafka.versaoConfigurarMicrokafka
    $microkafkaHost = $configuracoes.enderecos.ipHost

    (Get-Content -Path $arquivoDockerComposeDestino -Raw) -replace '\$TAG_MICROKAFKA',"$tagMicrokafka" | Set-Content -path $arquivoDockerComposeDestino
    (Get-Content -Path $arquivoDockerComposeDestino -Raw) -replace '\$TAG_CONFIGURAR_MICROKAFKA',"$tagConfigurarMicrokafka" | Set-Content -path $arquivoDockerComposeDestino
    (Get-Content -Path $arquivoDockerComposeDestino -Raw) -replace '\$MICROKAFKA_HOST',"$microkafkaHost" | Set-Content -path $arquivoDockerComposeDestino
}

function global:mu.microkafka.copiarEAjustarArquivosDeConfiguracao.test() {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $arquivoConfiguracao = "C:\temp\microuniversoWeb-microkafka.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $arquivoConfiguracao

    mu.microkafka.copiarEAjustarArquivosDeConfiguracao $configuracoes
}

function global:mu.microkafka.subirContainersMicrokafka() {
    param(
        $configuracoes
    )

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    $arquivoCompose = "$($configuracoes.enderecos.diretorioBaseInstalacao)\microkafka\docker-compose-microkafka.yml"

    docker-compose -f $arquivoCompose down
    docker-compose -f $arquivoCompose up -d

    $ErrorActionPreference = $ErrorActionPreference_back

}

function global:mu.microkafka.subirContainersMicrokafka.test() {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $arquivoConfiguracao = "C:\temp\microuniversoWeb-microkafka.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $arquivoConfiguracao

    mu.microkafka.subirContainersMicrokafka $configuracoes
}

function global:mu.microkafka.configurarMicrokafka() {
    param(
        $configuracoes
    )

    if ($configuracoes.microkafka.configurar -eq $false) {
        _echo "Configuracao do Microkafka desativada via arquivo de configuracao" warn
        return
    }

    if ($configuracoes.microkafka.sistema -eq "linux") {
        _echo "Configurando Microkafka para executar em containers Linux..."
    

        _echo "Microkafka sera configurado nas versoes: microkafka $($configuracoes.microkafka.versaoMicrokafka), configurar-microkafka $($configuracoes.microkafka.versaoConfigurarMicrokafka)"

        _echo "Microkafka - Fazendo login no reistry do docker"
        mu.microkafka.fazerLoginRegistroDocker $configuracoes

        _echo "Microkafka - Copiando arquivos de configuracao"
        mu.microkafka.copiarEAjustarArquivosDeConfiguracao $configuracoes

        _echo "Microkafka - Baixando imagens"
        mu.microkafka.baixarImagens $configuracoes

        _echo "Microkafka - Subindo containers"
        mu.microkafka.subirContainersMicrokafka $configuracoes

        _echo "Microkafka configurado"
    } elseif ($configuracoes.microkafka.sistema -eq "windows") {
        _echo "Configurando Microkafka para executar como servico do Windows..."

        mu.microkafkaWindows.configurar $configuracoes
    }

    
}

function global:mu.microkafka.configurarMicrokafka.test() {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $arquivoConfiguracao = "C:\temp\microuniversoWeb-microkafka.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $arquivoConfiguracao

    mu.microkafka.configurarMicrokafka $configuracoes
}