function global:mu.enterprise.fazerLoginRegistroDocker {
    param(
        $configuracoes
    )

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    $enderecoRegistro = $configuracoes.enterprise.imagem.nome.Split('/')[0]
    docker login $enderecoRegistro -u $configuracoes.enterprise.imagem.usuario -p $configuracoes.enterprise.imagem.senha 2> $null

    $ErrorActionPreference = $ErrorActionPreference_back
}

function global:mu.enterprise.copiarEAjustarArquivosDeConfiguracao {
    param(
        $configuracoes
    )

    $sistema = $configuracoes.enterprise.imagem.sistema
    $arquivoDockerComposeOrigem = "$PSScriptRoot\enterprise\docker-compose-enterprise-$sistema.yml"
    $arquivoConfigOrigem = "$PSScriptRoot\enterprise\config.env"
    
    $diretorioEnterprise = "$($configuracoes.enderecos.diretorioBaseInstalacao)\enterprise"

    $arquivoDockerComposeDestino = "$diretorioEnterprise\docker-compose-enterprise.yml"
    $arquivoConfigDestino = "$diretorioEnterprise\config.env"

    $nomeImagemCompleta = "$($configuracoes.enterprise.imagem.nome):$($configuracoes.enterprise.imagem.versao)"

    if (!(Test-Path -Path $diretorioEnterprise)) {
        New-Item -ItemType Directory $diretorioEnterprise
    }

    if (!(Test-Path -Path "$diretorioEnterprise\logs")) {
        New-Item -ItemType Directory "$diretorioEnterprise\logs"
    }

    if (!(test-path -path "$diretorioEnterprise\logs-event-handler")) {
        new-item -ItemType Directory "$diretorioEnterprise\logs-event-handler"
    }

    Copy-Item $arquivoDockerComposeOrigem $arquivoDockerComposeDestino
    Copy-Item $arquivoConfigOrigem $arquivoConfigDestino

    (Get-Content -Path $arquivoDockerComposeDestino -Raw) -replace '\$IMAGEM',"$nomeImagemCompleta" | Set-Content -Path $arquivoDockerComposeDestino
    (Get-Content -Path $arquivoDockerComposeDestino -Raw) -replace '\$PORTA',"$($configuracoes.enterprise.porta)" | Set-Content -Path $arquivoDockerComposeDestino
    (Get-Content -Path $arquivoDockerComposeDestino -Raw) -replace '\$MICROKAFKA_HOST',"$($configuracoes.enterprise.eventHandler.hostMicrokafka)" | Set-Content -Path $arquivoDockerComposeDestino

    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$DB_HOST',"$($configuracoes.acessos.banco.host)" | Set-Content -Path $arquivoConfigDestino
    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$DB_USER',"$($configuracoes.acessos.banco.usuario)" | Set-Content -Path $arquivoConfigDestino
    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$DB_PASSWORD',"$($configuracoes.acessos.banco.senha)" | Set-Content -Path $arquivoConfigDestino
    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$DB_NAME',"$($configuracoes.acessos.banco.nomeBanco)" | Set-Content -Path $arquivoConfigDestino
    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$DB_PORT',"1433" | Set-Content -Path $arquivoConfigDestino
    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$MU_DLL_REST_API_ADDRESS',"$($configuracoes.enderecos.ipHost)" | Set-Content -Path $arquivoConfigDestino
    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$MU_DLL_REST_API_PORT',"$($configuracoes.muDllRest.porta)" | Set-Content -Path $arquivoConfigDestino
    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$REST_LEGADO_HOST',"$($configuracoes.enderecos.ipHost)" | Set-Content -Path $arquivoConfigDestino
    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$REST_LEGADO_PORTA',"$($configuracoes.servicos.rest.porta)" | Set-Content -Path $arquivoConfigDestino
    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$AUTENTICACAO_USUARIO',"REST_LEGADO" | Set-Content -Path $arquivoConfigDestino
    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$USANDO_SQLSERVER_2008',"$($configuracoes.enterprise.usarSQLServer2008)" | Set-Content -Path $arquivoConfigDestino

    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$NEOCREDIT_ENVIO_PROCESSAMENTO_URL',"$($configuracoes.enterprise.neocredit.urlProcessamento)" | Set-Content -Path $arquivoConfigDestino
    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$NEOCREDIT_TOKEN',"$($configuracoes.enterprise.neocredit.tokenNeocredit)" | Set-Content -Path $arquivoConfigDestino
    (Get-Content -Path $arquivoConfigDestino -Raw) -replace '\$WEB_HOOK_URL',"$($configuracoes.enterprise.neocredit.urlWebhook)" | Set-Content -Path $arquivoConfigDestino
    
}

function global:mu.enterprise.subirContainerEnterprise {
    param(
        $configuracoes
    )

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    $arquivoCompose = "$($configuracoes.enderecos.diretorioBaseInstalacao)\enterprise\docker-compose-enterprise.yml"
    docker-compose -f $arquivoCompose down
    docker-compose -f $arquivoCompose up -d

    if ($configuracoes.enterprise.eventHandler.configurar -eq $false) {
        _echo "enterprise-event-handler desativado via configuracao" warn
        docker-compose -f $arquivoCompose rm -fs enterprise-event-handler
    }

    $ErrorActionPreference = $ErrorActionPreference_back
}

function global:mu.enterprise.copiarEAjustarArquivosDeConfiguracao.test {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $enderecoArquivoConfiguracao = "C:\temp\microuniversoWeb-microkafka.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao

    mu.enterprise.copiarEAjustarArquivosDeConfiguracao $configuracoes
}

function global:mu.enterprise.subirContainerEnterprise.test {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $enderecoArquivoConfiguracao = "C:\microuniversoWeb\microuniversoWeb-enterprise.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao

    mu.enterprise.subirContainerEnterprise $configuracoes
}

function global:mu.enterprise.criarDiretoriosDeVolumes {
    param(
        $configuracoes
    )

    $diretorioLogs = "$($configuracoes.enderecos.diretorioBaseInstalacao)\enterprise\logs"
    if (!(Test-Path $diretorioLogs)) {
        New-Item -ItemType Directory $diretorioLogs
    }

    $diretorioTemplatesRelatorios = "$($configuracoes.enderecos.diretorioBaseInstalacao)\enterprise\templates-relatorios-volume"
    if (!(Test-Path $diretorioTemplatesRelatorios)) {
        New-Item -ItemType Directory $diretorioTemplatesRelatorios
    }
}

function global:mu.enterprise.baixarImagem {
    param(
        $configuracoes
    )

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    $arquivoCompose = "$($configuracoes.enderecos.diretorioBaseInstalacao)\enterprise\docker-compose-enterprise.yml"
    docker-compose -f $arquivoCompose pull

    $ErrorActionPreference = $ErrorActionPreference_back
}

function global:mu.enterprise.configurarEnterprise {
    param(
        $configuracoes
    )

    if ($configuracoes.enterprise.configurar -eq $false) {
        _echo "Configuracao do Enterprise desativada via arquivo de configuracao" warn
        return
    }

    _echo "Enterprise sera configurado para $($configuracoes.enterprise.imagem.sistema)"

    _echo "Enterprise - Fazendo login no registro do docker"
    mu.enterprise.fazerLoginRegistroDocker $configuracoes

    _echo "Enterprise - Copiando arquivos de configuracao"
    mu.enterprise.copiarEAjustarArquivosDeConfiguracao $configuracoes

    _echo "Enterprise - Criando diretorios de volumes"
    mu.enterprise.criarDiretoriosDeVolumes $configuracoes

    _echo "Enterprise - Baixando imagem"
    mu.enterprise.baixarImagem $configuracoes

    _echo "Enterprise - Iniciando container"
    mu.enterprise.subirContainerEnterprise $configuracoes

    _echo "Enterprise - Configurado"
}

function global:mu.enterprise.configurarEnterprise.test {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $enderecoArquivoConfiguracao = "C:\temp\microuniversoWeb-enterprise-event-handler.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao

    mu.enterprise.configurarEnterprise $configuracoes
}