. $PSScriptRoot\configuracoesMicrouniversoWeb.ps1

function global:_mu.gerarCertificado.test() {

    
    
    # $configuracoes = @{
    #     enderecos = @{
    #         ipHost= "10.10.10.217"
    #     }
    #     certificado =@{
    #         configurar= $true
    #         nome= "MicroUniverso"
    #         nomeCertificadoPfx = "MicroUniverso.pfx"
    #         senhaExportar= "1q2w3e4r"
    #         arquivoconf= "san.cnf"
    #         diretorio= "C:\microuniversoWeb\certificados"
    #         validadeGerada= ""
    #         validoAte= ""
    #         ip= ""
    #     }
    # }

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter "C:\TrabalhoWeb\ScriptsDeploy\scripts_implantacao\arquivos-yml-teste\https.yaml"
    
    _mu.gerarCertificado -configuracoes $configuracoes
    
    
}

function global:_mu.gerarCertificado() {
    param(
        $configuracoes
    )

    if (!( $configuracoes.certificado.configurar)) {
        return _echo "Certificado digital nao sera configurado"
    }
    
    $openSSL = "C:\Program Files\Git\mingw64\bin\openssl.exe"
    $nomeArquivoCnf = "san.cnf"

    $certificadoAtual = Get-ChildItem -Path Cert:LocalMachine\MY | Where-Object {$_.FriendlyName -eq $($configuracoes.certificado.nome) } | Select-Object FriendlyName, Thumbprint, certificateHash, Subject, NotBefore, NotAfter

    if ($certificadoAtual){

        $ipCertificadoAtual = $certificadoAtual.Subject.Split('=')[1].Split(',')[0].split(':')[0]

        if ($ipCertificadoAtual -ne $($configuracoes.enderecos.ipHost))  {
            _echo "Removendo Certificado Gerado Para $ipCertificadoAtual"
            Get-ChildItem -Path Cert:LocalMachine\MY | Where-Object {$_.FriendlyName -eq $($configuracoes.certificado.nome)} | Remove-Item
            Get-ChildItem -Path Cert:LocalMachine\Root | Where-Object {$_.FriendlyName -eq $($configuracoes.certificado.nome)} | Remove-Item
        }
        else{
            _echo "Certificado Ja Existente. Pulando criacao do certificado"
            return
        }
    }

    $ipHost = $configuracoes.enderecos.ipHost

    _echo "Gerando certificado para $($configuracoes.enderecos.ipHost)"
    
    $validadeEmDias = "36500"

    if (-not (Test-Path -Path $configuracoes.certificado.diretorio)) {
        New-Item -Path $configuracoes.certificado.diretorio -ItemType Directory | Out-Null
       _echo "Criando Pasta : $($configuracoes.certificado.diretorio)"
    }

    $cnfContent = "
        [req]
        default_bits = 2048
        distinguished_name = req_distinguished_name
        req_extensions = req_ext
        x509_extensions = v3_req
        prompt = no

        [req_distinguished_name]
        countryName = XX
        stateOrProvinceName = N/A
        localityName = N/A
        organizationName = Self-signed certificate
        commonName = $($ipHost): Self-signed certificate

        [req_ext]
        subjectAltName = @alt_names
        basicConstraints        = CA:FALSE

        [v3_req]
        subjectAltName = @alt_names
        basicConstraints        = critical, CA:TRUE

        [alt_names]
        IP.1 =  $($ipHost)";

    
        $cnfContent| Out-File -Encoding ASCII -FilePath "$($configuracoes.certificado.diretorio)\$nomeArquivoCnf"

    $ErrorActionPreference_backup = $ErrorActionPreference

    $ErrorActionPreference = 'Continue'

    
    $argumentosParaGerarArquivosCertificado = "req -x509 -nodes -days $validadeEmDias -newkey rsa:2048 -keyout $($configuracoes.certificado.diretorio)\key.pem -out $($configuracoes.certificado.diretorio)\cert.pem -config $($configuracoes.certificado.diretorio)\$nomeArquivoCnf"

    Start-Process -FilePath $openSSL -ArgumentList $argumentosParaGerarArquivosCertificado -Wait

    $argumentosExportacaoCertificado = "pkcs12 -export -out $($configuracoes.certificado.diretorio)\$($configuracoes.certificado.nomeCertificadoPfx) -inkey $($configuracoes.certificado.diretorio)\key.pem -in $($configuracoes.certificado.diretorio)\cert.pem -passout pass:$($configuracoes.certificado.senhaExportar) -name $($configuracoes.certificado.nome)"

    Start-Process -FilePath $openSSL -ArgumentList $argumentosExportacaoCertificado -Wait

    Remove-Item "$($configuracoes.certificado.diretorio)\$nomeArquivoCnf"

    $ErrorActionPreference = $ErrorActionPreference_backup

    _mu.importarCertificado $configuracoes
}

function global:_mu.importarCertificado.test() {
    # $configuracoes = @{
    #     acessos = @{
    #         ipHost= "10.10.10.217"
    #     }
    #     certificado =@{
    #         configurar= $true
    #         nome= "MicroUniverso"
    #         nomeCertificadoPfx = "MicroUniverso.pfx"
    #         senhaExportar= "1q2w3e4r"
    #         arquivoconf= "san.cnf"
    #         diretorio= "C:\microuniversoWeb\certificados"
    #         validadeGerada= ""
    #         validoAte= ""
    #         ip= ""
    #     }
    # }

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter "C:\TrabalhoWeb\ScriptsDeploy\scripts_implantacao\arquivos-yml-teste\https.yaml"

    _mu.importarCertificado -configuracoes $configuracoes
}

function global:_mu.importarCertificado() {
    param(
        $configuracoes
    )
   
    $senhaCertificado =  ConvertTo-SecureString -String "$($configuracoes.certificado.senhaExportar)" -Force -AsPlainText

    $parametrosImportacao = @{
        FilePath = "$($configuracoes.certificado.diretorio)\$($configuracoes.certificado.nomeCertificadoPfx)"
        CertStoreLocation = 'Cert:\LocalMachine\My'
        Password = $senhaCertificado
    }

    $parametrosImportacaoRoot = @{
        FilePath = "$($configuracoes.certificado.diretorio)\$($configuracoes.certificado.nomeCertificadoPfx)"
        CertStoreLocation = 'Cert:\LocalMachine\Root'
        Password = $senhaCertificado
    }
    
    Import-PfxCertificate @parametrosImportacao
    Get-ChildItem -Path Cert:LocalMachine\Root | Where-Object {$_.FriendlyName -eq $($configuracoes.certificado.nome)} | Remove-Item
    Import-PfxCertificate @parametrosImportacaoRoot
}