. $PSScriptRoot\validarComandoAnterior.ps1

function global:mu.centralDeCadastros.copiarParaMicrouniversoWeb {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    $diretorioOrigem = "$diretorioReleaseWeb\$($configuracoes.centralDeCadastros.diretorioRelativoReleaseWeb)"
    $diretorioDestino = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.centralDeCadastros.diretorioRelativoInstalacao)"


    if (Test-Path -Path $diretorioDestino) {
        Remove-Item -Force -Recurse $diretorioDestino
    }

    Copy-Item -Path "$diretorioOrigem" -Destination $diretorioDestino -Recurse 
}

function global:mu.centralDeCadastros.copiarParaMicrouniversoWeb.test {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $enderecoArquivoConfiguracao = "C:\microuniversoWeb\microuniversoWeb-enterprise.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao
    $diretorioReleaseWeb = "C:\TrabalhoWeb\ReleaseWeb"

    mu.centralDeCadastros.copiarParaMicrouniversoWeb $configuracoes $diretorioReleaseWeb

}

function global:mu.centralDeCadastros.configurarEnderecoApi {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    $scriptConfigurarEnderecoApi = "$diretorioReleaseWeb\$($configuracoes.centralDeCadastros.diretorioRelativoReleaseWeb)\configurarEnderecoApi.ps1"
    $diretorioSite = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.centralDeCadastros.diretorioRelativoInstalacao)"
    $enderecoApi = "http://$($configuracoes.enderecos.ipHost):$($configuracoes.enterprise.porta)"

    & $scriptConfigurarEnderecoApi -enderecoBaseUrl $enderecoApi -diretorioBuild $diretorioSite


}

function global:mu.centralDeCadastros.configurarEnderecoApi.test {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $enderecoArquivoConfiguracao = "C:\microuniversoWeb\microuniversoWeb-enterprise.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao
    $diretorioReleaseWeb = "C:\TrabalhoWeb\ReleaseWeb"

    mu.centralDeCadastros.configurarEnderecoApi $configuracoes $diretorioReleaseWeb
}

function global:mu.centralDeCadastros.configurarSiteNoIIS {
    param(
        $configuracoes
    )

    $diretorioSite = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.centralDeCadastros.diretorioRelativoInstalacao)"

    $appcmd = "C:\\windows\\system32\\inetsrv\\appcmd.exe"
    $tempoSleep = 1

    _echo "Copiando arquivo web.config da Central de Cadastros"
    copy-item "$PSScriptRoot\centralDeCadastros\web.config" $diretorioSite

    _echo "Excluindo site CentralDeCadastros"
    & $appcmd delete site /site.name:CentralDeCadastros
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior

    _echo "Excluindo pool CentralDeCadastros"
    & $appcmd delete apppool /apppool.name:CentralDeCadastros
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior

    _echo "Criando pool CentralDeCadastros"
    & $appcmd add apppool /name:CentralDeCadastros /managedRuntimeVersion:v4.0 /managedPipelineMode:Integrated
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior

    _echo "Criando site CentralDeCadastros"
    & $appcmd add site /name:CentralDeCadastros /"physicalPath:$diretorioSite"
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior

    _echo "Removendo bindings CentralDeCadastros"
    & $appcmd set site /site.name:CentralDeCadastros /-bindings:"http/*:*:"
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior

    _echo "Configurando bindings CentralDeCadastros"
    & $appcmd set site /site.name:CentralDeCadastros /+"bindings.[protocol='http',bindingInformation='*:$($configuracoes.centralDeCadastros.porta):']"
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior


    _echo "Associando site ao pool CentralDeCadastros"
    & $appcmd set site /site.name:CentralDeCadastros /"[path='/'].applicationPool:CentralDeCadastros"
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior

    _echo "Realizando configuracoes adicionais no pool CentralDeCadastros"
    & $appcmd set apppool /apppool.name:CentralDeCadastros /startMode:AlwaysRunning /processModel.idleTimeout:00:00:00
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior

    _echo "Configurando identity pool CentralDeCadastros"
    & $appcmd set apppool /apppool.name:CentralDeCadastros /processModel.identityType:SpecificUser
    & $appcmd set apppool /apppool.name:CentralDeCadastros /processModel.userName:$($configuracoes.acessos.usuarioAdministrador.usuario)
    & $appcmd set apppool /apppool.name:CentralDeCadastros /processModel.password:$($configuracoes.acessos.usuarioAdministrador.senha)
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior

    _echo "Ativando preload CentralDeCadastros"
    & $appcmd set config -section:system.applicationHost/sites "/[name='CentralDeCadastros'].applicationDefaults.preloadEnabled:True" /commit:apphost
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior

    _echo "Parando e iniciando pool e site CentralDeCadastros"

    & $appcmd stop apppool /apppool.name:CentralDeCadastros
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior

    & $appcmd start apppool /apppool.name:CentralDeCadastros
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior

    & $appcmd stop site /site.name:CentralDeCadastros
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior

    & $appcmd start site /site.name:CentralDeCadastros
    Start-Sleep -Seconds $tempoSleep
    mu.validarComandoAnterior
}

function global:mu.centralDeCadastros.configurarSiteNoIIS.test {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $enderecoArquivoConfiguracao = "C:\microuniversoWeb\microuniversoWeb-enterprise.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao

    mu.centralDeCadastros.configurarSiteNoIIS $configuracoes

}

function global:mu.centralDeCadastros.configurarCentralDeCadastros {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    if ($configuracoes.centralDeCadastros.configurar -eq $false) {
        _echo "Central de cadastros desativada via configuracao" warn
        return
    }

    _echo "Configurando central de cadastros"

    _echo "Central De Cadastros - Copiando arquivos"
    mu.centralDeCadastros.copiarParaMicrouniversoWeb $configuracoes $diretorioReleaseWeb

    _echo "Central De Cadastros - Configurando endereco da API"
    mu.centralDeCadastros.configurarEnderecoApi $configuracoes $diretorioReleaseWeb

    _echo "Central De Cadastros - Configurando site no IIS"
    mu.centralDeCadastros.configurarSiteNoIIS $configuracoes
}

function global:mu.centralDeCadastros.configurarCentralDeCadastros.test {
    . $PSScriptRoot\.\configuracoesMicrouniversoWeb.ps1

    $enderecoArquivoConfiguracao = "C:\microuniversoWeb\microuniversoWeb-enterprise.yaml"
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter $enderecoArquivoConfiguracao
    $diretorioReleaseWeb = "C:\TrabalhoWeb\ReleaseWeb"

    mu.centralDeCadastros.configurarCentralDeCadastros $configuracoes $diretorioReleaseWeb

}