<#
.SYNOPSIS

Torna padrao a api enterprise ser executada em linux

altera:
    enterprise.imagem.sistema    

#>

. $PSScriptRoot\..\_echo.ps1
. $PSScriptRoot\..\configuracoesMicrouniversoWeb.ps1
. $PSScriptRoot\acpsFuncoesComuns.ps1

function global:_mu.acp8JaExecutada() {
    (test-path (mu.acp.obterCaminhoRegistroACPs)) -and (Get-itemProperty (mu.acp.obterCaminhoRegistroACPs)).acp8 -match "executada"
}

function global:_mu.executarAcp8() {
    param(
        [Parameter(Mandatory = $true)]
        [string]
        $enderecoArquivoConfiguracao
    )

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml $enderecoArquivoConfiguracao 

    $configuracoes.enterprise.imagem.sistema = 'linux'

    mu.configuracoesMicrouniversoWeb.salvar -configuracoes $configuracoes -enderecoYaml $enderecoArquivoConfiguracao

    New-ItemProperty $(mu.acp.obterCaminhoRegistroACPs) -Name acp8 -Value "executada;$(get-date -format yyyy-MM-dd-HH-mm-ss)" -force

}

function global:mu.acp8() {
    param(
        [Parameter(Mandatory = $true)]
        [string]
        $enderecoArquivoConfiguracao
    )

    mu.acp.criarCaminhoAcpsSeNecessario

    if ((_mu.acp8JaExecutada) -eq $false) {
        _mu.executarAcp8 -enderecoArquivoConfiguracao $enderecoArquivoConfiguracao
        _echo "ACP8 executada com sucesso"
    } else {
        _echo "ACP8 ja executada"
    }
}