<#
.SYNOPSIS

Torna padrao o microkafka ser executado em linux

altera:
    microkafka.sistema
    
    

#>

. $PSScriptRoot\..\_echo.ps1
. $PSScriptRoot\..\configuracoesMicrouniversoWeb.ps1
. $PSScriptRoot\acpsFuncoesComuns.ps1

function global:_mu.acp7JaExecutada() {
    (test-path (mu.acp.obterCaminhoRegistroACPs)) -and (Get-itemProperty (mu.acp.obterCaminhoRegistroACPs)).acp7 -match "executada"
}

function global:_mu.executarAcp7() {
    param(
        [Parameter(Mandatory = $true)]
        [string]
        $enderecoArquivoConfiguracao
    )

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml $enderecoArquivoConfiguracao 

    $configuracoes.microkafka.sistema = 'linux'

    mu.configuracoesMicrouniversoWeb.salvar -configuracoes $configuracoes -enderecoYaml $enderecoArquivoConfiguracao

    New-ItemProperty $(mu.acp.obterCaminhoRegistroACPs) -Name acp7 -Value "executada;$(get-date -format yyyy-MM-dd-HH-mm-ss)" -force

}

function global:mu.acp7() {
    param(
        [Parameter(Mandatory = $true)]
        [string]
        $enderecoArquivoConfiguracao
    )

    mu.acp.criarCaminhoAcpsSeNecessario

    if ((_mu.acp7JaExecutada) -eq $false) {
        _mu.executarAcp7 -enderecoArquivoConfiguracao $enderecoArquivoConfiguracao
        _echo "ACP7 executada com sucesso"
    } else {
        _echo "ACP7 ja executada"
    }
}