<#
.SYNOPSIS

Criptografa a senha do banco e do usuario no arquivo de configuracao

altera:
    acessos.banco.senha
    acessos.usuarioAdministrador.senha
    

#>

. $PSScriptRoot\..\_echo.ps1
. $PSScriptRoot\..\configuracoesMicrouniversoWeb.ps1
. $PSScriptRoot\acpsFuncoesComuns.ps1

function global:_mu.acp6JaExecutada() {
    (test-path (mu.acp.obterCaminhoRegistroACPs)) -and (Get-itemProperty (mu.acp.obterCaminhoRegistroACPs)).acp6 -match "executada"
}

function global:_mu.executarAcp6() {
    param(
        [Parameter(Mandatory = $true)]
        [string]
        $enderecoArquivoConfiguracao
    )

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml $enderecoArquivoConfiguracao 

    $charArraySenhaBanco = ("{NOVA}" + $($configuracoes.acessos.banco.senha)).ToCharArray()
    $configuracoes.acessos.banco.senha = ($charArraySenhaBanco | % {[int][char]$_ + 1 } | % {[char]$_} | % {$senhaCriptografada = ""} {$senhaCriptografada += $_} {$senhaCriptografada})

    $charArraySenhaUsuarioAdministrador = ("{NOVA}" + $($configuracoes.acessos.usuarioAdministrador.senha)).ToCharArray()
    $configuracoes.acessos.usuarioAdministrador.senha = ($charArraySenhaUsuarioAdministrador | % {[int][char]$_ + 1 } | % {[char]$_} | % {$senhaCriptografada = ""} {$senhaCriptografada += $_} {$senhaCriptografada})

    mu.configuracoesMicrouniversoWeb.salvar -configuracoes $configuracoes -enderecoYaml $enderecoArquivoConfiguracao

    New-ItemProperty $(mu.acp.obterCaminhoRegistroACPs) -Name acp6 -Value "executada;$(get-date -format yyyy-MM-dd-HH-mm-ss)" -force

}

function global:mu.acp6() {
    param(
        [Parameter(Mandatory = $true)]
        [string]
        $enderecoArquivoConfiguracao
    )

    mu.acp.criarCaminhoAcpsSeNecessario

    if ((_mu.acp6JaExecutada) -eq $false) {
        _mu.executarAcp6 -enderecoArquivoConfiguracao $enderecoArquivoConfiguracao
        _echo "ACP6 executada com sucesso"
    } else {
        _echo "ACP6 ja executada"
    }
}