<#
.SYNOPSIS

ACP necessaria para liberacao da versao beta, que torna o uso do fenix wrapper obrigatorio

altera:
    servicos.fenixWrapper.habilitar para true
    servicos.fenixWrapper.configurar para true
    servicos.rest.ignorarFenixWrapper para false
#>

. $PSScriptRoot\..\_echo.ps1
. $PSScriptRoot\..\configuracoesMicrouniversoWeb.ps1
. $PSScriptRoot\acpsFuncoesComuns.ps1

function global:_mu.acp2JaExecutada() {
    (test-path (mu.acp.obterCaminhoRegistroACPs)) -and (Get-itemProperty (mu.acp.obterCaminhoRegistroACPs)).acp2 -match "executada"
}

function global:_mu.acp2JaExecutada.test() {
    (_mu.acp2JaExecutada)
}

function global:_mu.executarAcp2() {
    param(
        [Parameter(Mandatory = $true)]
        [string]
        $enderecoArquivoConfiguracao
    )

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml $enderecoArquivoConfiguracao 

    write-host $configuracoes

    $configuracoes.servicos.fenixWrapper.habilitar = $true
    $configuracoes.servicos.fenixWrapper.configurar = $true
    $configuracoes.servicos.rest.ignorarFenixWrapper = $false

    mu.configuracoesMicrouniversoWeb.salvar -configuracoes $configuracoes -enderecoYaml $enderecoArquivoConfiguracao

    New-ItemProperty $(mu.acp.obterCaminhoRegistroACPs) -Name acp2 -Value "executada;$(get-date -format yyyy-MM-dd-HH-mm-ss)" -force

}

function global:mu.acp2() {
    param(
        [Parameter(Mandatory = $true)]
        [string]
        $enderecoArquivoConfiguracao
    )

    mu.acp.criarCaminhoAcpsSeNecessario

    if ((_mu.acp2JaExecutada) -eq $false) {
        _mu.executarAcp2 -enderecoArquivoConfiguracao $enderecoArquivoConfiguracao
        _echo "ACP2 executada com sucesso"
    } else {
        _echo "ACP2 ja executada"
    }
}

function global:mu.acp2.test() {
    mu.acp2 -enderecoArquivoConfiguracao "c:\temp\microuniversoWeb-teste-acp2.yaml"

}