. $PSScriptRoot\_echo.ps1

function global:mu.adicionarRegrasFirewall() {

    param(
        $configuracoes
    )
    

    $ErrorActionPreference_backup = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'
    Remove-NetFirewallRule -DisplayName "Microuniverso"
    $ErrorActionPreference = $ErrorActionPreference_backup

    $portas = @()

    # comentei as condicionais para adicionar as regras no firewall pq haverao casos, por exemplo, que o Enteprise ja esta em execucao
    # e o usuario reconfigura somente o OrcWeb. neste cenario, o acesso ao Enterprise seria perdido
    # o ideal eh ler a regra antes de alterar e manter as portas que ja estiverem liberadas
    # melhorar essa implementacao num futuro proximo
    # jonathan

    # if ($configuracoes.servicos.rest.configurar) {
        $portas += $configuracoes.servicos.rest.porta
    # }
    
    # if ($configuracoes.servicos.orcamentoWeb.configurar) {
        $portas += $configuracoes.servicos.orcamentoWeb.porta
    # }

    # if ($configuracoes.enterprise.configurar) {
        $portas += $configuracoes.enterprise.porta
    # }
    
    # if ($configuracoes.centralDeCadastros.configurar) {
        $portas += $configuracoes.centralDeCadastros.porta
    # }

    # if ($configuracoes.muDllRest.configurar) {
        $portas += $configuracoes.muDllRest.porta
    # }
    
    # if ($configuracoes.servicos.segurancaWeb.configurar) {
        $portas += $configuracoes.servicos.segurancaWeb.porta
    # }
    
    # if ($configuracoes.servicos.authServer.configurar) {
        $portas += $configuracoes.servicos.authServer.porta
    # }
    
    # if ($configuracoes.servicos.carrinhoDeCompra.configurar) {
        $portas += $configuracoes.servicos.carrinhoDeCompra.porta
    # }

    # if ($configuracoes.servicos.imagensProdutos.configurar) {
        $portas += $configuracoes.servicos.imagensProdutos.porta
    # }
    
    # if ($configuracoes.servicos.resourceServer.configurar) {
        $portas += $configuracoes.servicos.resourceServer.porta
    # }
    
    # if ($configuracoes.servicos.financeiro.configurar) {
        $portas += $configuracoes.servicos.financeiro.porta
    # }
    
    # if ($configuracoes.servicos.ordemDeCompra.configurar) {
        $portas += $configuracoes.servicos.ordemDeCompra.porta
    # }

    # if ($configuracoes.servicos.liberarPendencia.configurar) {
        $portas += $configuracoes.servicos.liberarPendencia.porta
    # }

    $portas += 9092
    $portas += 9093
    $portas += 2181

    #portas https
    $portas += $configuracoes.servicos.rest.portaHttps
    $portas += $configuracoes.servicos.orcamentoWeb.portaHttps
    $portas += $configuracoes.servicos.segurancaWeb.portaHttps
       
    New-NetFirewallRule -DisplayName "Microuniverso" -Direction Inbound -LocalPort $portas -Protocol TCP -Action Allow

    _echo "Portas liberadas no firewall: $portas"
}