from lib.echo import echo
from pathlib import Path
import yaml


def obter_configuracoes(arquivo_configuracao):
    if not arquivo_configuracao or not Path(arquivo_configuracao).exists():
        echo("Arquivo de configuracao nao informado ou inexistente", "error")
        return None
    
    with open(arquivo_configuracao, "r", encoding="utf-8") as f:
        configuracao = yaml.load(f, Loader=yaml.FullLoader)

    return configuracao



def salvar_configuracoes(arquivo_configuracao, dados):
    """
    Salva o dicionário `dados` no arquivo YAML especificado.
    Cria a pasta caso ela não exista.
    """

    if not arquivo_configuracao:
        echo("Caminho do arquivo de configuracao nao informado.", "error")
        return False

    caminho = Path(arquivo_configuracao)
    pasta = caminho.parent

    try:
        # Garante que a pasta existe
        if not pasta.exists():
            pasta.mkdir(parents=True, exist_ok=True)

        with open(caminho, "w", encoding="utf-8") as f:
            yaml.dump(
                dados,
                f,
                allow_unicode=True,
                default_flow_style=False,
                sort_keys=False
            )

        echo(f"Configuracoes salvas em: {caminho}", "success")
        return True

    except Exception as e:
        echo(f"Erro ao salvar configuracoes: {e}", "error")
        return False
