from lib.obter_configuracoes import obter_configuracoes
import sys
from lib.echo import echo
from lib.executar_validacoes_servidor_linux import executar_validacoes_servidor_linux
from lib.ClienteLinux import obter_cliente_linux



arquivo_configuracao = None if len(sys.argv) < 2 else sys.argv[1]
diretorio_scripts_implantacao = r'c:\microuniversoWeb\scriptsImplantacao' if len(sys.argv) < 3 else sys.argv[2]

configuracoes = obter_configuracoes(arquivo_configuracao)

if not configuracoes["acessos"]["servidorLinux"]["configurar"]:
    echo("Dados do servidor linux nao informados. Intercompany nao sera configurada")
    exit(0)

if not configuracoes["intercompany"]["configurar"]:
    echo("Configuracao intercompany desativada via configuracao")
    exit(0)


mensagem_erro = executar_validacoes_servidor_linux(arquivo_configuracao, diretorio_scripts_implantacao)    

if mensagem_erro:
    echo(mensagem_erro, "error")
    exit(1)

cliente_linux = obter_cliente_linux(arquivo_configuracao)

usuario = configuracoes['acessos']['servidorLinux']['usuario']

if cliente_linux.executar_comando(f"test ! -d /home/{usuario}/intercompany", disparar_excecao_se_retorno_nao_zero=False).codigo_retorno == 0:
    cliente_linux.executar_comando(f'mkdir /home/{usuario}/intercompany')

cliente_linux.copiar_arquivo(fr'{diretorio_scripts_implantacao}\intercompany\docker-compose-intercompany.yml' , f'/home/{usuario}/intercompany/docker-compose.yml')

url_api_enterprise = "{protocolo}://{host}:{porta}".format(
    protocolo="http",
    host=configuracoes["intercompany"]["hostEnterprise"],
    porta="9988"
)
porta_intercompany = configuracoes["intercompany"]["porta"]
versao = configuracoes["intercompany"]["versao"]
usuario_registro_docker = configuracoes["acessos"]["registroDocker"]["usuario"]
senha_registro_docker = configuracoes["acessos"]["registroDocker"]["senha"]


cliente_linux.executar_comando(fr'docker login gitlab.microuniverso.com.br:5050 -u {usuario_registro_docker} -p {senha_registro_docker}', disparar_excecao_se_retorno_nao_zero=False)



cliente_linux.executar_comando(fr"sed -i 's,\$URL_API_ENTERPRISE,{url_api_enterprise},g' /home/{usuario}/intercompany/docker-compose.yml")
cliente_linux.executar_comando(f"sed -i 's,\$PORTA,{porta_intercompany},g' /home/{usuario}/intercompany/docker-compose.yml")

cliente_linux.executar_comando(fr"sed -i 's,\$VERSAO,{versao},g' /home/{usuario}/intercompany/docker-compose.yml")
cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/intercompany/docker-compose.yml down')    
cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/intercompany/docker-compose.yml pull')    
cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/intercompany/docker-compose.yml up -d')    

exit(0)