param(
    [Parameter(Position=0,Mandatory = $true)]
    $versao,
    
    [Parameter(Mandatory = $true)]
    $usuarioFtp,

    [Parameter(Mandatory = $true)]
    $senhaFtp,

    [Parameter()]
    [Switch]
    $publicarParaProducao
)

$diretorioScriptsImplantacao = "C:\TrabalhoWeb\\ScriptsDeploy\\scripts_implantacao"
$ErrorActionPreference = 'Stop'

function realizarCommit() {
    param(
        $versao
    )

    git -C $diretorioScriptsImplantacao add --all
    git -C $diretorioScriptsImplantacao commit -m "scripts-implantacao v$versao"
    git -C $diretorioScriptsImplantacao push
}


function gerarArquivoZip() {
    $diretorioRelease = "$diretorioScriptsImplantacao\MicroUniverso.Instalador\bin\Release"
    $arquivoZip = "$diretorioRelease\Instalador-2020-11.zip"

    get-childitem $diretorioRelease | compress-archive -destinationPath $arquivoZip -update
}

function atualizarArquivoVersoesNoFTP() {
    param(
        $versao
    )

    $enderecoArquivoLocal = "C:\temp\ultimas-versoes-softwares.txt"

    if (test-path $enderecoArquivoLocal) {
        remove-item $enderecoArquivoLocal
    }

    # baixar o arquivo
    $caminhoArquivoNoFtp = "download.microuniverso.com.br/Web Aplicativos/Fenix/Instalador/ultimas-versoes-softwares.txt"
    $enderecoArquivoRemoto = "ftp://$caminhoArquivoNoFtp"

    $ftpRequestDownload = [System.Net.FtpWebRequest]::Create($enderecoArquivoRemoto)
    $ftpRequestDownload.Credentials = new-object System.Net.NetworkCredential($usuarioFtp,$senhaFtp)
    $ftpRequestDownload.Method = [System.Net.WebRequestMethods+Ftp]::DownloadFile
    $ftpRequestDownload.UseBinary = $true
    $ftpRequestDownload.KeepAlive = $false
    $ftpResponse = $ftpRequestDownload.GetResponse()
    $responseStream = $ftpResponse.GetResponseStream()

    $arquivoLocal = new-object IO.FileStream ($enderecoArquivoLocal,[IO.FileMode]::Create)
    [byte[]]$readBuffer = new-object byte[] 1024

    do {
        $readLength = $responseStream.Read($readBuffer,0,1024)
        $arquivoLocal.Write($readBuffer,0,$readLength)
    } while ($readLength -ne 0)

    $arquivoLocal.Close()

    # modificar o arquivo
    ((Get-Content -path $enderecoArquivoLocal -raw) -replace 'scripts-implantacao.*',"scripts-implantacao:v$versao") | set-content -path $enderecoArquivoLocal

    #enviar o arquivo
    
    $ftpRequestUpload = [System.Net.FtpWebRequest]::Create($enderecoArquivoRemoto)
    $ftpRequestUpload.Method = [System.Net.WebRequestMethods+Ftp]::UploadFile
    $ftpRequestUpload.Credentials = new-object System.Net.NetworkCredential($usuarioFtp, $senhaFtp)
    $ftpRequestUpload.UseBinary = $true
    $ftpRequestUpload.UsePassive = $true

    $conteudoArquivo = get-content -en byte $enderecoArquivoLocal
    $ftpRequestUpload.ContentLength = $conteudoArquivo.Length
    $run = $ftpRequestUpload.GetRequestStream()
    $run.Write($conteudoArquivo,0,$conteudoArquivo.Length)
    $run.Close()
    $run.Dispose()

}

function enviarArquivoParaFtp() {
    $versaoNoFtp = if ($publicarParaProducao) { "latest" } else {$versao}
    $caminhoArquivoNoFtp = "download.microuniverso.com.br/Web Aplicativos/Fenix/Instalador/ScriptsImplantacao/ScriptsImplantacao-$versaoNoFtp.zip"
    $enderecoArquivoRemoto = "ftp://$caminhoArquivoNoFtp"

    $enderecoArquivoLocal = "$diretorioScriptsImplantacao\ScriptsImplantacao-$versaoNoFtp.zip"

    $client = New-Object System.Net.WebClient
    $client.Credentials = New-Object System.Net.NetworkCredential($usuarioFtp, $senhaFtp)
    $client.UploadFile($enderecoArquivoRemoto,$enderecoArquivoLocal)
}

if ($publicarParaProducao) {

    write-host "Atualizando versao no package.json"
    npm --prefix $diretorioScriptsImplantacao version $versao --allow-same-version
}

start-sleep 5

if ($publicarParaProducao) {

    write-host "Fazendo commit no git"
    realizarCommit $versao
}

start-sleep 5

write-host "Gerando arquivo .zip"
if ($publicarParaProducao) {
    npm --prefix $diretorioScriptsImplantacao run build -- -versao latest
} else {
    npm --prefix $diretorioScriptsImplantacao run build -- -versao $versao
}

start-sleep 5

write-host "Enviando arquivo para FTP"
enviarArquivoParaFtp

start-sleep 5

if ($publicarParaProducao) {
    write-host "Atualizando arquivo de versoes no ftp"
    atualizarArquivoVersoesNoFTP $versao
}





