. $PSScriptRoot\_echo.ps1

function global:_mu.necessarioReiniciarIIS() {
    param(
        $configuracoes
    )

    $configuracoes.servicos.rest.configurar -or `
    $configuracoes.servicos.authServer.configurar -or `
    $configuracoes.servicos.resourceServer.configurar -or `
    $configuracoes.servicos.segurancaWeb.configurar -or `
    $configuracoes.servicos.imagensProdutos.configurar -or `
    $configuracoes.servicos.orcamentoWeb.configurar -or `
    $configuracoes.servicos.carrinhoDeCompra.configurar -or `
    $configuracoes.servicos.financeiro.configurar -or `
    $configuracoes.servicos.ordemDeCompra.configurar -or `
    $configuracoes.servicos.liberarPendencia.configurar -or `
    $configuracoes.centralDeCadastros.configurar
    
}

function global:_mu.necessarioPararWCF() {
    param(
        $configuracoes
    )

    $configuracoes.servicos.orcamentoWeb.configurar
}

function global:_mu.necessarioPararFenixWrapper() {
    param(
        $configuracoes
    )

    $configuracoes.servicos.orcamentoWeb.configurar -or `
    ($configuracoes.servicos.rest.configurar -and $configuracoes.servicos.rest.ignorarFenixWrapper -eq $false)
}

function global:mu.pararProcessosEServicosNecessarios() {
    param(
        $configuracoes
    )

    if ((_mu.necessarioReiniciarIIS $configuracoes)) {
        _echo "Parando IIS"
        iisreset /stop
    } else {
        _echo "IIS nao sera parado, nenhum servico que sera configurado depende dele sera configurado"
    }

    if ((_mu.necessarioPararWCF $configuracoes)) {
        _echo "Parando processos WCF (MicroUniverso.Venda.Orcamento.Host.Console.exe)"
        TASKKILL /F /FI "IMAGENAME eq MicroUniverso.Venda.Orcamento.Host.Console.exe"
    } else {
        _echo "Processos MicroUniverso.Venda.Orcamento.Host.Console.exe nao serao parados, nenhum servico que depende dele sera configurado"
    }

    if ((_mu.necessarioPararFenixWrapper $configuracoes)) {
        _echo "Parando processo FenixWrapper (FenixWrapper.exe)"
        TASKKILL /F /FI "IMAGENAME eq FenixWrapper.exe"
    } else {
        _echo "Processos FenixWrapper.exe nao serao parados, nenhum servico que depende dele sera configurado"
    }
}