const axios = require('axios').default;
const expect = require('chai').expect;
const argv = require('process').argv;

async function obterDadosDaPagina() {
    const resposta = await axios.get('http://download.microuniverso.com.br/TradSql/Utilitarios/SRVCUSTO/');
    return resposta.data;
}

async function listarArquivos(data) {
    const regex = /href="(srvcusto(\d+)\.zip)"/g;
    let match;
    const filteredLinks = [];

    while ((match = regex.exec(data)) !== null) {
        filteredLinks.push({ href: match[1], number: match[2] });
    }

    return filteredLinks;
}

function processarSaida(listaArquivos) {
    return listaArquivos.map(arquivo => arquivo.number).join("\n");
}

function extrairNumeroDeArquivo(nomeArquivo) {
    const match = nomeArquivo.match(/srvcusto(\d+)\.zip/);
    return match == null ? "" : match[1];
}

async function main() {
    try {
        const data = await obterDadosDaPagina();
        const listaArquivos = await listarArquivos(data);
        const saida = processarSaida(listaArquivos);
        return saida;
    } catch (error) {
        console.error('Erro ao buscar os arquivos:', error);
        return null;
    }
}

main().then(lista => {
    if (lista != null) {
        console.log(lista);
    }
});
