const {encryptFileAES,decryptFileAES} = require('./encryptUtils')
const { argv } = require('yargs')

async function main() {
    const mode = argv['mode']
    const source = argv['source']
    const destination = argv['destination']
    const password = argv['password'].toString()

    await (mode == "encrypt" ? encryptFileAES({
        filePathPlainText: source,
        filePathEncrypted: destination,
        password: password
    }) : decryptFileAES({
        filePathEncrypted: source,
        filePathDecrypted: destination,
        password: password
    }))


}

main().then(() => process.exit(0)).catch(_error => {
    console.log('houve erro')
    process.exit(1)
})