. $PSScriptRoot\_echo.ps1
. $PSScriptRoot\configuracoesMicrouniversoWeb.ps1

function global:mu.copiarMigrations() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )


    $diretorioMigrationOrigem = "$diretorioReleaseWeb\migration"
    $diretorioMigrationsOrigem = "$diretorioReleaseWeb\migrations"

    $diretorioMigrationDestino = "$($configuracoes.enderecos.diretorioBaseInstalacao)\migration"
    $diretorioMigrationsDestino = "$($configuracoes.enderecos.diretorioBaseInstalacao)\migrations"

    if (-not (test-path $diretorioMigrationOrigem)) {
        _echo "Diretorio de migrations nao encontrado em $diretorioMigrationOrigem. Migrations nao serao executadas" error
        return
    }

    if (test-path $diretorioMigrationDestino) {
        remove-item -force -recurse $diretorioMigrationDestino
    }

    if (test-path $diretorioMigrationsDestino) {
        remove-item -force -recurse $diretorioMigrationsDestino
    }

    copy-item -recurse $diretorioMigrationOrigem $diretorioMigrationDestino
    copy-item -recurse $diretorioMigrationsOrigem $diretorioMigrationsDestino

}

function global:mu.copiarMigrations.test() {
    $configuracoes = mu.configuracoesMicrouniversoWeb.obter C:\TrabalhoWeb\ScriptsDeploy\scripts_implantacao\microuniversoWeb-modelo.yaml

    mu.copiarMigrations $configuracoes C:\TrabalhoWeb\ReleaseWeb
}