. $PSScriptRoot\obterEnderecoHttpServico.ps1
. $PSScriptRoot\validarComandoAnterior.ps1

function global:_mu.configurarLiberarPendencia() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    if ($configuracoes.servicos.liberarPendencia.configurar -eq $false) {
        _echo "Liberar pendencia desativado via configuracao" warn
        return
    }

    $diretorioInstalacao = $configuracoes.enderecos.diretorioBaseInstalacao
    $diretorioApp = "$diretorioInstalacao\$($configuracoes.servicos.liberarPendencia.diretorioRelativoInstalacao)"
    $enderecoArquivoConfigurarAngular = "$diretorioReleaseWeb\ConfigurarAngular.ps1"
    $enderecoRest = _mu.obterEnderecoHttpServico $configuracoes rest
    $enderecoLiberarPendencia = _mu.obterEnderecoHttpServico $configuracoes liberarPendencia
    $enderecoCarrinhoDeCompra = _mu.obterEnderecoHttpServico $configuracoes carrinhoDeCompra

    mu.validarComandoAnterior

    # powershell Set-ExecutionPolicy UnRestricted

    powershell -file $enderecoArquivoConfigurarAngular -arquivojs $diretorioApp\main.bundle.js -restendpoint $enderecoRest -microappendpoint $enderecoLiberarPendencia -shopcartendpoint $enderecoCarrinhoDeCompra

    mu.validarComandoAnterior

    powershell -file $enderecoArquivoConfigurarAngular -arquivojs $diretorioApp\main.bundle.map -restendpoint %REST% -microappendpoint $enderecoLiberarPendencia -shopcartendpoint $enderecoCarrinhoDeCompra

    mu.validarComandoAnterior

    powershell -file $enderecoArquivoConfigurarAngular -arquivojs $diretorioApp\index.html -restendpoint $enderecoLiberarPendencia

    mu.validarComandoAnterior

    # powershell Set-ExecutionPolicy UnRestricted

    # powershell -file ConfigurarAngular.ps1 -arquivojs C:\microUniversoWeb\app\orcamento\MicroUniverso.App\main.bundle.js -restendpoint %REST% -microappendpoint http://%IP%:%MICROUNIVERSOAPP_PORT% -shopcartendpoint http://%IP%:%CARRINHODECOMPRA_PORT%

    # powershell -file ConfigurarAngular.ps1 -arquivojs C:\microUniversoWeb\app\orcamento\MicroUniverso.App\main.bundle.map -restendpoint %REST% -microappendpoint http://%IP%:%MICROUNIVERSOAPP_PORT% -shopcartendpoint http://%IP%:%CARRINHODECOMPRA_PORT%

    # powershell -file ConfigurarAngular.ps1 -arquivojs C:\microUniversoWeb\app\orcamento\MicroUniverso.App\index.html -restendpoint http://%IP%:%MICROUNIVERSOAPP_PORT%
}

function global:_mu.configurarOrdemDeCompra() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    if ($configuracoes.servicos.ordemDeCompra.configurar -eq $false) {
        _echo "Ordem de compra desativado via configuracao" warn
        return
    }

    $diretorioInstalacao = $configuracoes.enderecos.diretorioBaseInstalacao
    $diretorioApp = "$diretorioInstalacao\$($configuracoes.servicos.ordemDeCompra.diretorioRelativoInstalacao)"
    $enderecoArquivoConfigurarAngular = "$diretorioReleaseWeb\ConfigurarAngular.ps1"
    $enderecoRest = _mu.obterEnderecoHttpServico $configuracoes rest
    $enderecoOrdemDeCompra = _mu.obterEnderecoHttpServico $configuracoes ordemDeCompra

    mu.validarComandoAnterior

    powershell -file $enderecoArquivoConfigurarAngular -arquivojs $diretorioApp\main.bundle.js -restendpoint $enderecoRest

    mu.validarComandoAnterior

    powershell -file $enderecoArquivoConfigurarAngular -arquivojs $diretorioApp\main.bundle.js.map -restendpoint $enderecoRest

    mu.validarComandoAnterior

    powershell -file $enderecoArquivoConfigurarAngular -arquivojs $diretorioApp\index.html -restendpoint $enderecoOrdemDeCompra

    mu.validarComandoAnterior

    

}

function global:_mu.configurarCarrinhoDeCompra() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    if ($configuracoes.servicos.carrinhoDeCompra.configurar -eq $false) {
        _echo "Carrinho de compra desativado via configuracao" warn
        return
    }

    $diretorioInstalacao = $configuracoes.enderecos.diretorioBaseInstalacao
    $diretorioApp = "$diretorioInstalacao\$($configuracoes.servicos.carrinhoDeCompra.diretorioRelativoInstalacao)"
    $enderecoArquivoConfigurarAngular = "$diretorioReleaseWeb\ConfigurarAngular.ps1"
    $enderecoRest = _mu.obterEnderecoHttpServico $configuracoes rest
    $enderecoLiberarPendencia = _mu.obterEnderecoHttpServico $configuracoes liberarPendencia
    $enderecoCarrinhoDeCompra = _mu.obterEnderecoHttpServico $configuracoes carrinhoDeCompra

    powershell -file $enderecoArquivoConfigurarAngular -arquivojs $diretorioApp\index.html -restendpoint $enderecoCarrinhoDeCompra

    powershell -file $enderecoArquivoConfigurarAngular -arquivojs $diretorioApp\main.js -restendpoint $enderecoRest -microappendpoint $enderecoLiberarPendencia

}

function global:mu.configurarApps() {
    param(
        $configuracoes,
        $diretorioReleaseWeb
    )

    _mu.configurarLiberarPendencia $configuracoes $diretorioReleaseWeb

    _mu.configurarOrdemDeCompra $configuracoes $diretorioReleaseWeb

    _mu.configurarCarrinhoDeCompra $configuracoes $diretorioReleaseWeb
}