$p = [Environment]::GetEnvironmentVariable("PSModulePath")
$p += ";C:\microuniversoWeb\psmodules"
[Environment]::SetEnvironmentVariable("PSModulePath",$p)

import-module powershell-yaml

. $PSScriptRoot\_echo.ps1
. $PSScriptRoot\encriptacao\encryptUtils.ps1

# FUNCOES PUBLICAS


function global:mu.configuracoesMicrouniversoWeb.salvar() {
    param(
        [Parameter(Mandatory = $true)]
        $configuracoes,

        [Parameter(Mandatory = $true)]
        $enderecoYaml,

        [Parameter(Mandatory = $false)]
        $senha,

        [Parameter(Mandatory = $false)]
        $enderecoChavePublica,

        [Parameter(Mandatory = $false)]
        $excluirArquivoLimpo
    )

    if (!(Get-Module -ListAvailable -Name "powershell-yaml")) {
        throw "Modulo powershell-yaml nao instalado. Execute o instalador para baixa-lo"
    }

    $configuracoesYaml = $configuracoes | ConvertTo-Yaml

    if (!$PSBoundParameters.ContainsKey("senha") -or $null -eq $senha -or !$PSBoundParameters.ContainsKey("$enderecoChavePublica") -or $null -eq $enderecoChavePublica) {
        _mu.configuracoesMicrouniversoWeb.salvar.arquivoLimpo    -configuracoesYaml $configuracoesYaml `
                                                            -enderecoYaml $enderecoYaml
    } else  {
        _mu.configuracoesMicrouniversoWeb.salvar.arquivoEnc  -configuracoesYaml $configuracoesYaml `
                                                        -enderecoYaml $enderecoYaml `
                                                        -senha $senha

        _mu.configuracoesMicrouniversoWeb.salvar.arquivoEncm    -configuracoesYaml $configuracoesYaml `
                                                            -enderecoYaml $enderecoYaml `
                                                            -enderecoChavePublica $enderecoChavePublica

        if (test-path $enderecoYaml) {
            if ($PSBoundParameters.ContainsKey("excluirArquivoLimpo") -and $excluirArquivoLimpo -eq $true) {
                remove-item $enderecoYaml
            } 
            
        }                                                            
    } 
}

function global:mu.configuracoesMicrouniversoWeb.obter() {
    param(
        [Parameter(Mandatory = $true)]
        [string]
        $enderecoYaml,

        [string]
        [Parameter(Mandatory = $false)]
        $senha
    )

    $arquivoJsonTemporario = "c:\temp\microuniversoWeb.json"

    $configuracoes = if (test-path $enderecoYaml) {
        _mu.configuracoesMicrouniversoWeb.obter.arquivoLimpo -enderecoYaml $enderecoYaml `
                                                        -arquivoJsonTemporario $arquivoJsonTemporario
    } elseif (test-path "$enderecoYaml.enc") {
        _mu.configuracoesMicrouniversoWeb.obter.arquivoEnc   -enderecoYaml $enderecoYaml `
                                                        -arquivoJsonTemporario $arquivoJsonTemporario `
                                                        -senha $senha
    } else {
        $null
    }

    if (test-path $arquivoJsonTemporario) {
        remove-item $arquivoJsonTemporario
    }

    # remover arquivo temporario antigo devido a instalacoes anteriores
    # este trecho pode ser removido em algumas semanas
    if (test-path "c:\temp\orcamentoWeb.json") {
        remove-item "c:\temp\orcamentoWeb.json"
    }

    return $configuracoes
}

function global:mu.configuracoesMicrouniversoWeb.atualizarHistoricoInstalacoes() {
    param(
        $configuracoes,
        $referencia
    )

    $configuracoes.historicoInstalacoes += "$(get-date -format 'yyyy-MM-dd-HH-mm')::$referencia"

    $configuracoes
}


# FUNCOES PRIVADAS

function global:_mu.configuracoesMicrouniversoWeb.obter.arquivoLimpo() {
    param(
        $enderecoYaml,
        $arquivoJsonTemporario
    )

    # $configuracoes = get-content -path $enderecoYaml | ConvertFrom-Yaml

    # remove-item $arquivoJsonTemporario

    $ErrorActionPreference_back = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'

    js-yaml $enderecoYaml > $arquivoJsonTemporario 2> out-null

    $configuracoes = get-content -path $arquivoJsonTemporario -Raw | ConvertFrom-Json

    $ErrorActionPreference = $ErrorActionPreference_back

    return $configuracoes
}

function global:_mu.configuracoesMicrouniversoWeb.obter.arquivoEnc() {
    param(
        $enderecoYaml,
        $arquivoJsonTemporario,
        $senha
    )

    $arquivoEnc = "$enderecoYaml.enc"
    $arquivoDenc = "$enderecoYaml.denc"

    $resultadoDecriptacao = mu.decriptografarArquivoConfiguracaoUsandoSenha     -enderecoArquivoCriptografado $arquivoEnc `
                                                                                -enderecoArquivoDecriptografado $arquivoDenc `
                                                                                -senha $senha

    if ($resultadoDecriptacao -eq $false) {
        $null
    } else {
        $configuracoes = _mu.configuracoesMicrouniversoWeb.obter.arquivoLimpo    -enderecoYaml $arquivoDenc `
                                                                            -arquivoJsonTemporario $arquivoJsonTemporario

        remove-item $arquivoDenc

        $configuracoes
    }
}

function global:_mu.configuracoesMicrouniversoWeb.obter.arquivoEncm() {
    param(
        $enderecoYaml,
        $arquivoJsonTemporario,
        $senha
    )

    $arquivoEncm = "$enderecoYaml.encm"
    $arquivoDencm = "$enderecoYaml.dencm"

    $masterKeyMuDenc = mu.decriptografarMasterKeyMu -senha $senha

    $resultadoDecriptacao = mu.decriptografarArquivoConfiguracao -enderecoArquivoCriptografado $arquivoEncm `
                            -enderecoArquivoLimpo $arquivoDencm `
                            -senha $masterKeyMuDenc

    return if ($resultadoDecriptacao -eq $false) {
        $null
    } else {
        $configuracoes = _mu.configuracoesMicrouniversoWeb.obter.arquivoLimpo -enderecoYaml $arquivoDencm `
                        -arquivoJsonTemporario $arquivoJsonTemporario

        remove-item $arquivoDencm

        $configuracoes
    }

}

function global:_mu.configuracoesMicrouniversoWeb.salvar.arquivoLimpo() {
    param(
        $confiracoesYaml,
        $enderecoYaml
    )

    $configuracoesYaml | out-file -encoding utf8 $enderecoYaml

}

function global:_mu.configuracoesMicrouniversoWeb.salvar.arquivoEnc() {
    param(
        $configuracoesYaml,
        $enderecoYaml,
        $senha
    )

    $arquivoEnc = "$enderecoYaml.enc"

    $configuracoesYaml | out-file -encoding utf8 $enderecoYaml

    mu.criptografarArquivoConfiguracaoUsandoSenha   -enderecoArquivoLimpo $enderecoYaml `
                                                    -enderecoArquivoCriptografado $arquivoEnc `
                                                    -senha $senha `
                                                    -excluirArquivoLimpo $false

}

function global:_mu.configuracoesMicrouniversoWeb.salvar.arquivoEncm() {
    param(
        $configuracoesYaml,
        $enderecoYaml,
        $enderecoChavePublica
    )

    $arquivoEncm = "$enderecoYaml.encm"

    $configuracoesYaml | out-file -encoding utf8 $enderecoYaml

    mu.criptografarArquivoConfiguracaoUsandoChavePublica    -enderecoArquivoLimpo $enderecoYaml `
                                                            -enderecoArquivoCriptografado $arquivoEncm `
                                                            -enderecoChavePublica $enderecoChavePublica `
                                                            -excluirArquivoLimpo $false
}

# TESTES

function global:mu.configuracoesMicrouniversoWeb.obter.test() {
    $enderecoYaml = "C:\microuniversoWeb\microuniversoWeb.yaml"

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml $enderecoYaml

    _echo $configuracoes
}

function global:mu.configuracoesMicrouniversoWeb.obter.test.senhaCorreta() {
    $enderecoYaml = "C:\microuniversoWeb\microuniversoWeb.yaml.modificado"
    $senha = "1234"

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter  -enderecoYaml $enderecoYaml `
                                                        -senha $senha
    
    _echo $configuracoes                                                        

}

function global:mu.configuracoesMicrouniversoWeb.obter.test.senhaErrada() {
    $enderecoYaml = "C:\microuniversoWeb\microuniversoWeb.yaml"
    $senha = "incorreta"

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter  -enderecoYaml $enderecoYaml `
                                                        -senha $senha
    
    if ($null -ne $configuracoes) {
        throw "variavel configuracoes deveria estar null"
    }                                               

}

function global:mu.configuracoesMicrouniversoWeb.salvar.test.salvarArquivoSemSenha() {
    $enderecoYamlOriginal = "C:\microuniversoWeb\microuniversoWeb.yaml"
    $enderecoYamlModificado = "C:\microuniversoWeb\microuniversoWeb.yaml.modificado"
    

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter  -enderecoYaml $enderecoYamlOriginal

    mu.configuracoesMicrouniversoWeb.salvar  -configuracoes $configuracoes `
                                        -enderecoYaml $enderecoYamlModificado
}

function global:mu.configuracoesMicrouniversoWeb.salvar.test.salvarArquivoComSenha() {
    $enderecoYamlOriginal = "C:\microuniversoWeb\microuniversoWeb.yaml"
    $enderecoYamlModificado = "C:\microuniversoWeb\microuniversoWeb.yaml.modificado"
    $enderecoChavePublica = "C:\mu-scripts\scripts_implantacao\encriptacao\microuniverso.pubkey"
    $senha = "1234"

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter  -enderecoYaml $enderecoYamlOriginal `
                                                        -senha $senha                                          

    mu.configuracoesMicrouniversoWeb.salvar  -configuracoes $configuracoes `
                                        -enderecoYaml $enderecoYamlModificado `
                                        -senha $senha `
                                        -enderecoChavePublica $enderecoChavePublica
}

function global:mu.configuracoesMicrouniversoWeb.mudarBranchOuTag.test() {
    $enderecoYaml = "C:\microuniversoWeb\microuniversoWeb.yaml"
    $senha = "1234"
    $enderecoChavePublica = "C:\mu-scripts\scripts_implantacao\encriptacao\microuniverso.pubkey"
    $novaBranchOuTag = "FOO"

    mu.configuracoesMicrouniversoWeb.mudarBranchOuTag   -enderecoYaml $enderecoYaml `
                                                    -senha $senha `
                                                    -novaBranchOuTag $novaBranchOuTag `
                                                    -enderecoChavePublica $enderecoChavePublica


    $configuracoes = mu.configuracoesMicrouniversoWeb.obter     -enderecoYaml $enderecoYaml `
                                                            -senha $senha
                
    
    if ($configuracoes.dadosRelease.referencia -ne $novaBranchOuTag) {
        throw "esperava que a branch no arquivo fosse $novaBranchOuTag"
    }
}

function global:mu.configuracoesMicrouniversoWeb.mudarDadosBanco.test() {
    $enderecoYaml = "C:\microuniversoWeb\microuniversoWeb.yaml"
    $senhaCriptografia = "1234"
    $enderecoChavePublica = "C:\mu-scripts\scripts_implantacao\encriptacao\microuniverso.pubkey"
    $usuario = "fulano"
    $senhaBanco = "bar"
    $host_ = "host1"
    $nomeBanco = "banco1"

    mu.configuracoesMicrouniversoWeb.mudarDadosBanco    -enderecoYaml $enderecoYaml `
                                                    -senhaCriptografia $senhaCriptografia `
                                                    -enderecoChavePublica $enderecoChavePublica `
                                                    -usuario $usuario `
                                                    -host $host_ `
                                                    -nomeBanco $nomeBanco `
                                                    -senhaBanco $senhaBanco

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml $enderecoYaml `
                                                        -senha $senhaCriptografia
                                                        
    if (
        $configuracoes.acessos.banco.usuario -ne $usuario -or
        $configuracoes.acessos.banco.senha -ne $senhaBanco -or
        $configuracoes.acessos.banco.host -ne $host_ -or
        $configuracoes.acessos.banco.nomeBanco -ne $nomeBanco
    ) {
        throw "esperava que os dados estivessem modificados"
    }

}

function global:mu.configuracoesMicrouniversoWeb.atualizarHistoricoInstalacoes.test() {
    $enderecoYaml = "C:\microuniversoWeb\microuniversoWeb.yaml"
    $senha = "123"
    $enderecoChavePublica = "C:\TrabalhoWeb\ScriptsDeploy\scripts_implantacao\microuniverso.pubkey"


    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml $enderecoYaml -senha $senha
    _echo $configuracoes.historicoInstalacoes

    $configuracoesAtualizadas = mu.configuracoesMicrouniversoWeb.atualizarHistoricoInstalacoes -configuracoes $configuracoes -referencia "foo"

    mu.configuracoesMicrouniversoWeb.salvar     -configuracoes $configuracoesAtualizadas `
                                                -enderecoYaml $enderecoYaml `
                                                -senha $senha `
                                                -enderecoChavePublica $enderecoChavePublica `
                                                -excluirArquivoLimpo $false

}