. $PSScriptRoot\_echo.ps1

function global:_mu.backupSegurancaWeb() {
    param(
        $configuracoes,
        $diretorioBaseBackupDataAtual
    )

    $diretorioBaseInstalacao = $configuracoes.enderecos.diretorioBaseInstalacao
    $diretorioInstalacao = "$diretorioBaseInstalacao\$($configuracoes.servicos.segurancaWeb.diretorioRelativoInstalacao)"

    $diretorioBackup = "$diretorioBaseBackupDataAtual\$($configuracoes.servicos.segurancaWeb.nomeSite)"

    new-item $diretorioBackup -ItemType Directory -ErrorAction Ignore

    if (test-path $diretorioInstalacao\Templates) {
        copy-item $diretorioInstalacao\Templates $diretorioBackup -recurse -force
    } else {
        _echo "Diretorio Templates inexistente para site $($configuracoes.servicos.segurancaWeb.nomeSite)"
    }

    if (test-path $diretorioInstalacao\images) {
        copy-item $diretorioInstalacao\images $diretorioBackup -recurse -force
    } else {
        _echo "Diretorio images inexistente para site $($configuracoes.servicos.segurancaWeb.nomeSite)"
    }
    
}

# alteracao teste

function global:_mu.backupRest() {
    param(
        $configuracoes,
        $diretorioBaseBackupDataAtual
    )

    $diretorioBaseInstalacao = $configuracoes.enderecos.diretorioBaseInstalacao
    $diretorioInstalacao = "$diretorioBaseInstalacao\$($configuracoes.servicos.rest.diretorioRelativoInstalacao)"

    $diretorioBackup = "$diretorioBaseBackupDataAtual\$($configuracoes.servicos.rest.nomeSite)"

    new-item $diretorioBackup -ItemType Directory -ErrorAction Ignore

    if (test-path $diretorioInstalacao\Templates) {
        copy-item $diretorioInstalacao\Templates $diretorioBackup -recurse -force
    } else {
        _echo "Diretorio Templates inexistente para site $($configuracoes.servicos.rest.nomeSite)"
    }

    
    
}

function global:_mu.restaurarSegurancaWeb() {
    param(
        $configuracoes
    )

    $diretorioBaseBackupArquivos = $configuracoes.enderecos.diretorioBaseBackupArquivos
    $ultimoBackup = (ls $diretorioBaseBackupArquivos | Sort-Object -Property Name -Descending)[0].Name

    $diretorioOrigem = "$diretorioBaseBackupArquivos\$ultimoBackup\$($configuracoes.servicos.segurancaWeb.nomeSite)"
    $diretorioDestino = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.segurancaWeb.diretorioRelativoInstalacao)"

    if (Test-Path $diretorioOrigem\Templates) {
        Copy-Item $diretorioOrigem\Templates $diretorioDestino -recurse -Force
    } else {
        _echo "Diretorio de templates $diretorioOrigem\Templates nao encontrado"
    }

    if (Test-Path $diretorioOrigem\images) {
        Copy-Item $diretorioOrigem\images $diretorioDestino -recurse -Force
    } else {
        _echo "Diretorio de images $diretorioOrigem\images nao encontrado"
    }

    return ""

}

function global:_mu.restaurarRest() {
    param(
        $configuracoes
    )

    $diretorioBaseBackupArquivos = $configuracoes.enderecos.diretorioBaseBackupArquivos
    $ultimoBackup = (ls $diretorioBaseBackupArquivos | Sort-Object -Property Name -Descending)[0].Name

    $diretorioOrigem = "$diretorioBaseBackupArquivos\$ultimoBackup\$($configuracoes.servicos.rest.nomeSite)"
    $diretorioDestino = "$($configuracoes.enderecos.diretorioBaseInstalacao)\$($configuracoes.servicos.rest.diretorioRelativoInstalacao)"

    if (Test-Path $diretorioOrigem\Templates) {
        Copy-Item $diretorioOrigem\Templates $diretorioDestino -recurse -Force
    } else {
        _echo "Diretorio de templates $diretorioOrigem\Templates nao encontrado"
    }

    return ""

}

function global:mu.fazerBackupArquivos() {
    param(
        $configuracoes
    )

    $diretorioBaseBackupArquivos = $configuracoes.enderecos.diretorioBaseBackupArquivos

    $diretorioBackupDataAtual = "$diretorioBaseBackupArquivos\$(get-date -format yyyy-MM-dd-HH-mm-ss)"
    
    new-item -path $diretorioBackupDataAtual -ItemType Directory | out-null

    _mu.backupSegurancaWeb $configuracoes $diretorioBackupDataAtual | out-null

    _mu.backupRest $configuracoes $diretorioBackupDataAtual | out-null

    $diretorioBackupDataAtual

    
}

function global:mu.restaurarBackupArquivos() {
    param(
        $configuracoes
    )

    _mu.restaurarSegurancaWeb $configuracoes

    _mu.restaurarRest $configuracoes
}