<#
.SYNOPSIS

ACP necessaria para liberacao inicial da versao 3.0.0 do Orcamento Web

altera:
    servicos.fenixWrapper.habilitar para true
    servicos.fenixWrapper.configurar para true
    servicos.rest.ignorarFenixWrapper para true
#>

. $PSScriptRoot\..\_echo.ps1
. $PSScriptRoot\..\configuracoesMicrouniversoWeb.ps1
. $PSScriptRoot\acpsFuncoesComuns.ps1


function global:_mu.acp1JaExecutada() {
    (test-path (mu.acp.obterCaminhoRegistroACPs)) -and (Get-itemProperty (mu.acp.obterCaminhoRegistroACPs)).acp1 -match "executada"
}

function global:_mu.acp1JaExecutada.test() {
    (_mu.acp1JaExecutada)
}

function global:_mu.executarAcp1() {
    param(
        [Parameter(Mandatory = $true)]
        [string]
        $enderecoArquivoConfiguracao
    )

    $configuracoes = mu.configuracoesMicrouniversoWeb.obter -enderecoYaml $enderecoArquivoConfiguracao 

    $configuracoes.servicos.fenixWrapper.habilitar = $true
    $configuracoes.servicos.fenixWrapper.configurar = $true
    $configuracoes.servicos.rest.ignorarFenixWrapper = $true

    mu.configuracoesMicrouniversoWeb.salvar -configuracoes $configuracoes -enderecoYaml $enderecoArquivoConfiguracao

    New-ItemProperty $(mu.acp.obterCaminhoRegistroACPs) -Name acp1 -Value "executada;$(get-date -format yyyy-MM-dd-HH-mm-ss)" -force

}

function global:mu.acp1() {

    param(
        [Parameter(Mandatory = $true)]
        [string]
        $enderecoArquivoConfiguracao
    )

    mu.acp.criarCaminhoAcpsSeNecessario

    if ((_mu.acp1JaExecutada) -eq $false) {
        _mu.executarAcp1 -enderecoArquivoConfiguracao $enderecoArquivoConfiguracao
        _echo "ACP1 executada com sucesso"
    } else {
        _echo "ACP1 ja executada"
    }
}

function global:mu.acp1.test() {
    mu.acp1 -enderecoArquivoConfiguracao "C:\temp\microuniversoWeb-acp1.yaml"

}