from http.server import BaseHTTPRequestHandler, HTTPServer
import json

PORT = 9988

class MockHandler(BaseHTTPRequestHandler):
    def do_GET(self):
        # Corpo do retorno
        data = {
            "status": "ok",
            "rota": self.path,
            "porta": PORT
        }

        # Resposta HTTP
        self.send_response(200)
        self.send_header("Content-Type", "application/json")
        self.end_headers()

        # Enviar JSON
        self.wfile.write(json.dumps(data).encode("utf-8"))

# Iniciar o servidor
if __name__ == "__main__":
    print(f"Mock rodando em http://0.0.0.0:{PORT}")
    server = HTTPServer(("0.0.0.0", PORT), MockHandler)
    server.serve_forever()
