import-module -name $PSScriptRoot\..\dadosValidacao.psm1

function global:mu.validador.versaoPowerShell() {
    param(
        [Parameter(ValueFromPipeline)]
        $dadosValidacao
    )

    if ($dadosValidacao.configuracaoValida -eq $false) {
        return $dadosValidacao
    }

    _echo "Verificando versao do powershell"

    if ($PSVersionTable.PSVersion.Major -lt 5) {
        $dadosValidacao.codigoErro = "E0003"
        $dadosValidacao.configuracaoValida = $false
        $dadosValidacao.mensagemErro = "Necessario powershell 5 ou superior"
    }

    return $dadosValidacao
}