import-module -name $PSScriptRoot\..\dadosValidacao.psm1
. $PSScriptRoot\..\..\_echo.ps1

function global:mu.validador.acessoAoBancoWMS() {
    [Parameter(ValueFromPipeline)]
    $dadosValidacao

    if ($dadosValidacao.configuracaoValida -eq $false) {
        return $dadosValidacao
    }

    $prosseguirComVerificacao = $dadosValidacao.configuracoes.monitorWMS.configurar

    if (-not $prosseguirComVerificacao) {
        return $dadosValidacao
    }

    _echo "Verificando acesso ao banco do WMS"

    $usuario = $dadosValidacao.configuracoes.monitorWMS.banco.usuario
    $banco = $dadosValidacao.configuracoes.monitorWMS.banco.nome
    $enderecoHost = $dadosValidacao.configuracoes.monitorWMS.banco.host
    $enderecoHostCorrigido = $enderecoHost -replace "\\","/"
    $senha = $dadosValidacao.configuracoes.monitorWMS.banco.senha

    $_ErrorActionPreference = $ErrorActionPreference
    $ErrorActionPreference = 'Continue'    

    $out = npm run --prefix $PSScriptRoot\..\..\ testar-acesso-ao-banco -- --user $usuario --password $senha --host $enderecoHostCorrigido --database $banco

    $resultado = $out -match "ERRO$"

    if ($resultado -eq "ERRO") {
        $dadosValidacao.configuracaoValida = $false
        $dadosValidacao.codigoErro = "E000B"
        $dadosValidacao.mensagemErro = "Nao foi possivel se conectar ao banco de dados do WMS"
    }

    return $dadosValidacao
}