import sys
from lib.echo import echo
from lib.ClienteLinux import obter_cliente_linux
from lib.obter_configuracoes import obter_configuracoes
from pathlib import Path
from lib.executar_validacoes_servidor_linux import executar_validacoes_servidor_linux

arquivo_configuracao = None if len(sys.argv) < 2 else sys.argv[1]
diretorio_scripts_implantacao = r'c:\microuniversoWeb\scriptsImplantacao' if len(sys.argv) < 3 else sys.argv[2]

configuracoes = obter_configuracoes(arquivo_configuracao)

if not configuracoes:
    echo(f"Falha ao carregar configuracoes do arquivo {arquivo_configuracao}" , "error")
    exit(1)

if not configuracoes["acessos"]["servidorLinux"]["configurar"]:
    echo("Dados do servidor linux nao informados. Storybook do Intercompany nao sera configurado")
    exit(0)    

if not configuracoes["intercompany"]["storybook"]["configurar"]:
    echo(f"Configuracao do Storybook do Intercompany desativada via configuracao")
    exit(0)

mensagem_erro = executar_validacoes_servidor_linux(arquivo_configuracao, diretorio_scripts_implantacao)

if mensagem_erro:
    echo(mensagem_erro, "error")
    exit(1)

cliente_linux = obter_cliente_linux(arquivo_configuracao)    

usuario = configuracoes['acessos']['servidorLinux']['usuario']  
usuario_registro_docker = configuracoes["acessos"]["registroDocker"]["usuario"]
senha_registro_docker = configuracoes["acessos"]["registroDocker"]["senha"]

cliente_linux.executar_comando(fr'docker login gitlab.microuniverso.com.br:5050 -u {usuario_registro_docker} -p {senha_registro_docker}', disparar_excecao_se_retorno_nao_zero=False)  

cliente_linux.executar_comando(f"mkdir -p /home/{usuario}/intercompany")    

cliente_linux.copiar_arquivo(fr'{diretorio_scripts_implantacao}\intercompany\docker-compose-storybook.yml' , f'/home/{usuario}/intercompany/docker-compose-storybook.yml')

versao_storybook_intercompany = configuracoes["intercompany"]["storybook"]["versao"]
host_storybook_intercompany = configuracoes["acessos"]["servidorLinux"]["host"]
porta_storybook_intercompany = configuracoes["intercompany"]["storybook"]["porta"]

cliente_linux.executar_comando(fr"sed -i 's,\$VERSAO_STORYBOOK,{versao_storybook_intercompany},g' /home/{usuario}/intercompany/docker-compose-storybook.yml")
cliente_linux.executar_comando(fr"sed -i 's,\$PORTA,{porta_storybook_intercompany},g' /home/{usuario}/intercompany/docker-compose-storybook.yml")

cliente_linux.executar_comando(fr'docker compose -f /home/{usuario}/intercompany/docker-compose-storybook.yml down')
cliente_linux.executar_comando(fr'docker compose -f /home/{usuario}/intercompany/docker-compose-storybook.yml up -d')

exit(0)