import sys
from lib.echo import echo
from lib.ClienteLinux import obter_cliente_linux
from lib.obter_configuracoes import obter_configuracoes
from pathlib import Path
from lib.executar_validacoes_servidor_linux import executar_validacoes_servidor_linux

arquivo_configuracao = None if len(sys.argv) < 2 else sys.argv[1]
diretorio_scripts_implantacao = r'c:\microuniversoWeb\scripts_implantacao' if len(sys.argv) < 3 else sys.argv[2]

configuracoes = obter_configuracoes(arquivo_configuracao)

if not configuracoes:
    echo(f"Falha ao carregar configuracoes do arquivo {arquivo_configuracao}" , "error")
    exit(1)

if not configuracoes["acessos"]["servidorLinux"]["configurar"]:
    echo("Dados do servidor linux nao informados. Microkafka nao sera configurado")
    exit(0)

if not configuracoes["microkafka"]["configurar"]:
    echo(f"Configuracao do Microkafka desativada via configuracao")
    exit(0)

mensagem_erro = executar_validacoes_servidor_linux(arquivo_configuracao, diretorio_scripts_implantacao)

if mensagem_erro:
    echo(mensagem_erro, "error")
    exit(1)


cliente_linux = obter_cliente_linux(arquivo_configuracao)
    

usuario = configuracoes['acessos']['servidorLinux']['usuario']  
usuario_registro_docker = configuracoes["acessos"]["registroDocker"]["usuario"]
senha_registro_docker = configuracoes["acessos"]["registroDocker"]["senha"]

cliente_linux.executar_comando(fr'docker login gitlab.microuniverso.com.br:5050 -u {usuario_registro_docker} -p {senha_registro_docker}', disparar_excecao_se_retorno_nao_zero=False)


  

if cliente_linux.executar_comando(f"test ! -d /home/{usuario}/microkafka", disparar_excecao_se_retorno_nao_zero=False).codigo_retorno == 0:
    cliente_linux.executar_comando(f'mkdir /home/{usuario}/microkafka')    

cliente_linux.copiar_arquivo(fr'{diretorio_scripts_implantacao}\microkafka\docker-compose-microkafka.yml' , f'/home/{usuario}/microkafka/docker-compose.yml')

versao_microkafka = configuracoes["microkafka"]["versaoMicrokafka"]
versao_configurar_microkafka = configuracoes["microkafka"]["versaoConfigurarMicrokafka"]
host_microkafka = configuracoes["acessos"]["servidorLinux"]["host"]
porta_microkafka_ui = configuracoes["microkafka"]["portaMicrokafkaUI"]

cliente_linux.executar_comando(fr"sed -i 's,\$TAG_MICROKAFKA,{versao_microkafka},g' /home/{usuario}/microkafka/docker-compose.yml")
cliente_linux.executar_comando(fr"sed -i 's,\$TAG_CONFIGURAR_MICROKAFKA,{versao_configurar_microkafka},g' /home/{usuario}/microkafka/docker-compose.yml")
cliente_linux.executar_comando(fr"sed -i 's,\$MICROKAFKA_HOST,{host_microkafka},g' /home/{usuario}/microkafka/docker-compose.yml")
cliente_linux.executar_comando(fr"sed -i 's,\$PORTA_MICROKAFKA_UI,{porta_microkafka_ui},g' /home/{usuario}/microkafka/docker-compose.yml")

cliente_linux.executar_comando(fr'docker compose -f /home/{usuario}/microkafka/docker-compose.yml down')
cliente_linux.executar_comando(fr'docker compose -f /home/{usuario}/microkafka/docker-compose.yml pull')
cliente_linux.executar_comando(fr'docker compose -f /home/{usuario}/microkafka/docker-compose.yml up -d')


exit(0)