from lib.ClienteLinux import obter_cliente_linux
from lib.echo import echo
import sys
from pathlib import Path
from lib.obter_configuracoes import obter_configuracoes
from lib.criptografia_senha import descriptografar
from lib.executar_validacoes_servidor_linux import executar_validacoes_servidor_linux
from lib.backup_volume import fazer_backup_volume_docker, restaurar_backup_volume_docker


arquivo_configuracao = None if len(sys.argv) < 2 else sys.argv[1]
diretorio_scripts_implantacao = r'c:\microuniversoWeb' if len(sys.argv) < 3 else sys.argv[2]

configuracoes = obter_configuracoes(arquivo_configuracao)

if not configuracoes:
    echo(f"Falha ao carregar configuracoes do arquivo {arquivo_configuracao}" , "error")
    exit(1)

if not configuracoes["acessos"]["servidorLinux"]["configurar"]:
    echo("Dados do servidor linux nao informados. API Enterprise nao sera configurada")
    exit(0)

if not configuracoes["enterprise"]["configurar"]:
    echo(f"Configuracao da API Enterprise desativada via configuracao")
    exit(0)

mensagem_erro = executar_validacoes_servidor_linux(arquivo_configuracao, diretorio_scripts_implantacao)    

if mensagem_erro:
    echo(mensagem_erro, "error")
    exit(1)

cliente_linux = obter_cliente_linux(arquivo_configuracao)


usuario = configuracoes['acessos']['servidorLinux']['usuario']    


if cliente_linux.executar_comando(f"test ! -d /home/{usuario}/enterprise", disparar_excecao_se_retorno_nao_zero=False).codigo_retorno == 0:
    cliente_linux.executar_comando(f'mkdir /home/{usuario}/enterprise')
    
configurar_renderizador = configuracoes["enterprise"]["renderizador"]["configurar"]

compose_normal = "docker-compose-enterprise-linux.yml"
compose_renderizador = "docker-compose-renderizador.yml"


cliente_linux.copiar_arquivo(fr'{diretorio_scripts_implantacao}\enterprise\docker-compose-enterprise-linux.yml' , f'/home/{usuario}/enterprise/'+ compose_normal)
cliente_linux.copiar_arquivo(fr'{diretorio_scripts_implantacao}\enterprise\docker-compose-renderizador.yml' , f'/home/{usuario}/enterprise/'+ compose_renderizador)

imagem_enterprise = configuracoes["enterprise"]["imagem"]["nome"] + ":" + configuracoes["enterprise"]["imagem"]["versao"]
configurar_event_handler = configuracoes["enterprise"]["eventHandler"]["configurar"]
microkafka_host = configuracoes["enterprise"]["eventHandler"]["hostMicrokafka"]
host_banco = configuracoes["acessos"]["banco"]["host"]
usuario_banco = configuracoes["acessos"]["banco"]["usuario"]
senha_banco = descriptografar(configuracoes["acessos"]["banco"]["senha"])
nome_banco = configuracoes["acessos"]["banco"]["nomeBanco"]
ip_host = configuracoes["enderecos"]["ipHost"]
porta_mu_dll_rest = configuracoes["muDllRest"]["porta"]
porta_enterprise = configuracoes["enterprise"]["porta"]
neocredit_envio_processamento_url = configuracoes["enterprise"]["neocredit"]["urlProcessamento"]
neocredit_token = configuracoes["enterprise"]["neocredit"]["tokenNeocredit"]
neocredit_url_webhook = configuracoes["enterprise"]["neocredit"]["urlWebhook"]
porta_rest_legado = configuracoes["servicos"]["rest"]["porta"]
sql_server_2008 = "S" if configuracoes["enterprise"]["usarSQLServer2008"] else "N"
usuario_registro_docker = configuracoes["acessos"]["registroDocker"]["usuario"]
senha_registro_docker = configuracoes["acessos"]["registroDocker"]["senha"]
ativar_reprocessamento_custo_medio_online = "S" if configuracoes["enterprise"]["reprocessamentoCustoMedioOnline"]["ativar"] else "N"
hora_reprocessamento_custo_medio_online = configuracoes["enterprise"]["reprocessamentoCustoMedioOnline"]["hora"]
minuto_reprocessamento_custo_medio_online = configuracoes["enterprise"]["reprocessamentoCustoMedioOnline"]["minuto"]
ativar_job_retorno_coleta_preco_sigepro = "S" if configuracoes["coletaPrecos"]["agenda"]["ativar"] else "N"
valor_hora_cron_job_retorno_coleta_preco_sigepro = configuracoes["coletaPrecos"]["agenda"]["hora"]
token_acesso_logs = configuracoes["enterprise"]["tokenAcessoLogs"]
api_key_integracao_tecnospeed = configuracoes["enterprise"]["tecnospeed"]["apikey"]

ip_enterprise = configuracoes["servicos"]["rest"]["hostEnterprise"]

porta_mu_whatsapp = configuracoes["muWhatsapp"]["porta"]

imagem_renderizador = configuracoes["enterprise"]["renderizador"]["imagem"]["nome"] + ":" + configuracoes["enterprise"]["imagem"]["versao"]
porta_renderizador = configuracoes["enterprise"]["renderizador"]["porta"]
memoria_minima_em_mb_heap_renderizador = configuracoes["enterprise"]["renderizador"]["memoriaMinimaEmMB"]
memoria_maxima_em_mb_heap_renderizador = configuracoes["enterprise"]["renderizador"]["memoriaMaximaEmMB"]

configurar_api_mu_whatsapp = configuracoes["muWhatsapp"]["configurarApi"]



cliente_linux.executar_comando(fr'docker login gitlab.microuniverso.com.br:5050 -u {usuario_registro_docker} -p {senha_registro_docker}', disparar_excecao_se_retorno_nao_zero=False)

for arquivo in [compose_normal, compose_renderizador]:

    cliente_linux.executar_comando(fr"sed -i 's,\$IMAGEM,{imagem_enterprise},g' /home/{usuario}/enterprise/" + arquivo)

    cliente_linux.executar_comando(f"sed -i 's,\$PORTA,{porta_enterprise},g' /home/{usuario}/enterprise/" + arquivo)

    cliente_linux.executar_comando(f"sed -i 's,\$MICROKAFKA_HOST,{microkafka_host},g' /home/{usuario}/enterprise/" + arquivo)

    
cliente_linux.executar_comando(fr"sed -i 's,\$RENDERIZADOR_IMAGEM,{imagem_renderizador},g' /home/{usuario}/enterprise/" + compose_renderizador)
cliente_linux.executar_comando(f"sed -i 's,\$RENDERIZADOR_PORTA,{porta_renderizador},g' /home/{usuario}/enterprise/" + compose_renderizador)
cliente_linux.executar_comando(f"sed -i 's,\$MEMORIA_MINIMA_RENDERIZADOR,{memoria_minima_em_mb_heap_renderizador},g' /home/{usuario}/enterprise/" + compose_renderizador)
cliente_linux.executar_comando(f"sed -i 's,\$MEMORIA_MAXIMA_RENDERIZADOR,{memoria_maxima_em_mb_heap_renderizador},g' /home/{usuario}/enterprise/" + compose_renderizador)

cliente_linux.copiar_arquivo(fr'{diretorio_scripts_implantacao}\enterprise\config.env' , f'/home/{usuario}/enterprise/config.env')

cliente_linux.executar_comando(fr"sed -i 's,\$AUTENTICACAO_USUARIO,REST_LEGADO,g' /home/{usuario}/enterprise/config.env")
host_banco_ajustado = host_banco.replace("\\","\\\\")
cliente_linux.executar_comando(fr"sed -i 's,\$DB_HOST,{host_banco_ajustado},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$DB_NAME,{nome_banco},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$DB_PASSWORD,{senha_banco},g' /home/{usuario}/enterprise/config.env", echoar=False,descricao="Alterando senha do banco")
cliente_linux.executar_comando(fr"sed -i 's,\$DB_PORT,1433,g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$DB_USER,{usuario_banco},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$MU_DLL_REST_API_ADDRESS,{ip_host},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$MU_DLL_REST_API_PORT,{porta_mu_dll_rest},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$NEOCREDIT_ENVIO_PROCESSAMENTO_URL,{neocredit_envio_processamento_url},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$NEOCREDIT_TOKEN,{neocredit_token},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$REST_LEGADO_HOST,{ip_host},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$REST_LEGADO_PORTA,{porta_rest_legado},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$WEB_HOOK_URL,{neocredit_url_webhook},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$USANDO_SQLSERVER_2008,{sql_server_2008},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$ATIVAR_JOB_REPROCESSAMENTO_CUSTO_MEDIO_ONLINE,{ativar_reprocessamento_custo_medio_online},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$VALOR_HORA_CRON_JOB_REPROCESSAMENTO_CUSTO_MEDIO_ONLINE,{hora_reprocessamento_custo_medio_online},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$VALOR_MINUTO_CRON_JOB_REPROCESSAMENTO_CUSTO_MEDIO_ONLINE,{minuto_reprocessamento_custo_medio_online},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$ATIVAR_JOB_RETORNO_COLETA_PRECO_SIGEPRO,{ativar_job_retorno_coleta_preco_sigepro}, g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$VALOR_HORA_CRON_JOB_RETORNO_COLETA_PRECO_SIGEPRO,{valor_hora_cron_job_retorno_coleta_preco_sigepro},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$TOKEN_ACESSO_LOGS,{token_acesso_logs},g' /home/{usuario}/enterprise/config.env")


cliente_linux.executar_comando(fr"sed -i 's,\$MU_WHATSAPP_API_HOST,{ip_enterprise},g' /home/{usuario}/enterprise/config.env")
cliente_linux.executar_comando(fr"sed -i 's,\$MU_WHATSAPP_API_PORT,{porta_mu_whatsapp},g' /home/{usuario}/enterprise/config.env")
    
cliente_linux.executar_comando(fr"sed -i 's,\$API_KEY_INTEGRACAO_TECNOSPEED,{api_key_integracao_tecnospeed},g' /home/{usuario}/enterprise/config.env")

try:
    fazer_backup_volume_docker("enterprise_tokens-muwhatsapp-volume", arquivo_configuracao)
except Exception as e:
    echo(f"[WARN] Falha ao fazer backup do volume 'enterprise_tokens-muwhatsapp-volume': {str(e)}", "info")
    
try:
    cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/enterprise/{compose_renderizador} down')
except Exception as e:
    echo(f"[WARN] Falha ao dar down no compose renderizador ({compose_renderizador}): {str(e)}", "info")
    
try:
    cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/enterprise/{compose_normal} down')
except Exception as e:
    echo(f"[WARN] Falha ao dar down no compose normal ({compose_normal}): {str(e)}", "info")

arquivo_docker_compose = compose_renderizador if configurar_renderizador else compose_normal

try:
    cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/enterprise/' + arquivo_docker_compose + ' pull')    
    cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/enterprise/' + arquivo_docker_compose + ' up -d')    
except Exception as e:
    echo(f"Não foi possível configurar a Api Enterprise com o Renderizador.Configurando apenas a Api Enterprise no lugar. Detalhe do erro: {str(e)}", "info")
    cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/enterprise/' + compose_normal + ' pull')    
    cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/enterprise/' + compose_normal + ' up -d')    

if not configurar_event_handler:
    cliente_linux.executar_comando(f'docker compose -f /home/{usuario}/enterprise/' + arquivo_docker_compose + ' rm -fs enterprise-event-handler')

try:
    if configurar_api_mu_whatsapp:
        restaurar_backup_volume_docker("enterprise_tokens-muwhatsapp-volume", arquivo_configuracao)
except Exception as e:
    echo(f"[WARN] Falha ao restaurar backup do volume 'enterprise_tokens-muwhatsapp-volume' após a configuração: {str(e)}", "info")

exit(0)
