import subprocess
import os
import sys

def atualizar_arquivo_configuracao(
    endereco_arquivo_configuracao: str,
    endereco_modelo_arquivo_configuracao_atualizado: str,
    endereco_arquivo_configuracao_atualizado: str
):
    npm_path = r"C:\nvm4w\nodejs\npm.cmd"

    script_root = os.path.dirname(os.path.abspath(__file__))

    comando = [
        npm_path,
        "run",
        "--prefix",
        os.path.dirname(script_root),
        "updateConfigurationFile",
        "--",
        "--currentConfigurationFilePath", endereco_arquivo_configuracao,
        "--updatedModelConfigurationFilePath", endereco_modelo_arquivo_configuracao_atualizado,
        "--outputFilePath", endereco_arquivo_configuracao_atualizado
    ]

    resultado = subprocess.run(
        comando,
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
        text=True,
        cwd=os.path.dirname(script_root)
    )

    if resultado.returncode != 0:
        raise Exception(
            f"Falha ao executar updateConfigurationFile:\n"
            f"STDOUT:\n{resultado.stdout}\n"
            f"STDERR:\n{resultado.stderr}"
        )

    return resultado.stdout


if __name__ == "__main__":
    if len(sys.argv) != 4:
        print("Uso: atualizar_arquivo_configuracao.py <arquivoAtual> <arquivoModelo> <arquivoSaida>")
        sys.exit(1)

    print(
        atualizar_arquivo_configuracao(
            sys.argv[1],
            sys.argv[2],
            sys.argv[3]
        )
    )
